/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.datasources;

import cn.opencodes.framework.core.datasources.DataSource;
import cn.opencodes.framework.core.datasources.DynamicDataSource;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class DataSourceAspect {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(cn.opencodes.framework.core.datasources.DataSource)")
    public void dataSourcePointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="dataSourcePointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        try {
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = point.getTarget().getClass().getMethod(signature.getName(), signature.getParameterTypes());
            DataSource ds = method.getAnnotation(DataSource.class);
            if (StringUtils.isNotBlank((String)ds.name())) {
                DynamicDataSource.setDataSource(ds.name());
                this.logger.debug("set datasource is " + ds.name());
            }
            Object object = point.proceed();
            return object;
        }
        finally {
            DynamicDataSource.clearDataSource();
            this.logger.debug("clean datasource");
        }
    }
}

