/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.base;

import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.BeanUtils;
import cn.opencodes.framework.tools.vo.PageBean;
import cn.opencodes.framework.tools.vo.Query;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseController {
    public Query query(Object ... objs) {
        Query query = new Query(objs);
        return query;
    }

    public Query query(HttpServletRequest req) {
        Map<String, Object> params = WebUtils.extractToMap(req);
        Query query = new Query(params);
        if (!this.isSuperAdmin()) {
            query.put("_curruserId", (Object)this.getUserId());
        }
        return query;
    }

    public Query query(Map<String, Object> params) {
        Query query = new Query(params);
        if (!this.isSuperAdmin()) {
            query.put("_curruserId", (Object)this.getUserId());
        }
        return query;
    }

    public UserRoot getUserRoot() {
        return WebUtils.getUser();
    }

    public String getUserName() {
        return this.getUserRoot().getUsername();
    }

    public long getUserId() {
        return this.getUserRoot().getId();
    }

    public boolean isSuperAdmin() {
        return this.getUserRoot().getSuperAdmin() == 1;
    }

    public <T> PageBean<T> copyPageBean(PageBean<?> page, Class<T> clasz) {
        LinkedList<T> dataList = new LinkedList<T>();
        List<?> list = page.getList();
        for (Object obj : list) {
            try {
                T t = clasz.newInstance();
                BeanUtils.copyBean2Bean(t, obj);
                dataList.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new PageBean(dataList, page.getTotal(), page.getCurrPage(), page.getPageSize());
    }

    public <T> List<T> copyList(List<?> list, Class<T> clasz) {
        LinkedList<T> dataList = new LinkedList<T>();
        for (Object obj : list) {
            try {
                T t = clasz.newInstance();
                BeanUtils.copyBean2Bean(t, obj);
                dataList.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataList;
    }

    public <T> T copyBean(Object obj, Class<T> clasz) {
        T t = null;
        try {
            t = clasz.newInstance();
            BeanUtils.copyBean2Bean(t, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }
}

