/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.autoconfigure;

import cn.opencodes.framework.autoconfigure.properties.AlphaProperties;
import cn.opencodes.framework.autoconfigure.properties.SwaggerProperties;
import com.github.xiaoymin.swaggerbootstrapui.annotations.EnableSwaggerBootstrapUI;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@EnableSwaggerBootstrapUI
public class SwaggerConfiguration {
    @Bean
    public Docket createRestApi(AlphaProperties props, SwaggerProperties swaConfig) {
        ArrayList<ResponseMessage> responseMessageList = new ArrayList<ResponseMessage>();
        Map<Integer, String> messages = swaConfig.getMessages();
        for (int key : messages.keySet()) {
            responseMessageList.add(new ResponseMessageBuilder().code(key).message(messages.get(key)).build());
        }
        return new Docket(DocumentationType.SWAGGER_2).globalResponseMessage(RequestMethod.GET, responseMessageList).globalResponseMessage(RequestMethod.POST, responseMessageList).globalResponseMessage(RequestMethod.PUT, responseMessageList).globalResponseMessage(RequestMethod.DELETE, responseMessageList).groupName(swaConfig.getGroupName()).apiInfo(this.apiInfo(swaConfig)).select().apis(RequestHandlerSelectors.basePackage((String)swaConfig.getBasePackage())).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes(props)).securityContexts(this.securityContexts(props));
    }

    private ApiInfo apiInfo(SwaggerProperties swaConfig) {
        return new ApiInfoBuilder().title(swaConfig.getTitle()).description(swaConfig.getDescription()).termsOfServiceUrl(swaConfig.getServiceUrl()).contact(new Contact(swaConfig.getAuthor(), swaConfig.getWebsit(), swaConfig.getEmail())).version(swaConfig.getVersion()).build();
    }

    private List<ApiKey> securitySchemes(AlphaProperties props) {
        String appKey = "appKey";
        String appSecret = "appSecret";
        String token = "token";
        if (props.isOpenSecret() && props.isOpenToken()) {
            return Lists.newArrayList((Object[])new ApiKey[]{new ApiKey(appKey, appKey, "header"), new ApiKey(appSecret, appSecret, "header"), new ApiKey(token, token, "header")});
        }
        if (props.isOpenSecret()) {
            return Lists.newArrayList((Object[])new ApiKey[]{new ApiKey(appKey, appKey, "header"), new ApiKey(appSecret, appSecret, "header")});
        }
        if (props.isOpenToken()) {
            return Lists.newArrayList((Object[])new ApiKey[]{new ApiKey(token, token, "header")});
        }
        return null;
    }

    private List<SecurityContext> securityContexts(AlphaProperties props) {
        return Lists.newArrayList((Object[])new SecurityContext[]{SecurityContext.builder().securityReferences(this.defaultAuth(props)).forPaths(PathSelectors.regex((String)"/*.*")).build()});
    }

    private List<SecurityReference> defaultAuth(AlphaProperties props) {
        String appKey = "appKey";
        String appSecret = "appSecret";
        String token = "token";
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("global", "accessEverything")};
        if (props.isOpenSecret() && props.isOpenToken()) {
            return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference(appKey, authorizationScopes), new SecurityReference(appSecret, authorizationScopes), new SecurityReference(token, authorizationScopes)});
        }
        if (props.isOpenSecret()) {
            return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference(appKey, authorizationScopes), new SecurityReference(appSecret, authorizationScopes)});
        }
        if (props.isOpenToken()) {
            return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference(token, authorizationScopes)});
        }
        return null;
    }
}

