/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.autoconfigure;

import cn.opencodes.framework.autoconfigure.properties.AlphaProperties;
import cn.opencodes.framework.core.shiro.AuthcRealm;
import cn.opencodes.framework.core.shiro.AuthcSecretFilter;
import cn.opencodes.framework.core.shiro.AuthcTokenFilter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.DelegatingFilterProxy;

public class ShiroConfiguration {
    @Bean
    public FilterRegistrationBean<DelegatingFilterProxy> shiroFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new DelegatingFilterProxy("shiroFilter"));
        registration.addInitParameter("targetFilterLifecycle", "true");
        registration.setEnabled(true);
        registration.setOrder(0x7FFFFFFE);
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Bean(value={"sessionManager"})
    public SessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdCookieEnabled(true);
        return sessionManager;
    }

    @Bean(value={"securityManager"})
    public SecurityManager securityManager(SessionManager sessionManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)new AuthcRealm());
        securityManager.setSessionManager(sessionManager);
        return securityManager;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shirFilter(SecurityManager securityManager, AlphaProperties props) {
        ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
        shiroFilter.setSecurityManager(securityManager);
        shiroFilter.setLoginUrl("/" + props.getModule() + props.getLoginUrl());
        shiroFilter.setSuccessUrl("/index.html");
        LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
        filterMap.put("/swagger-ui.html", "anon");
        filterMap.put("/webjars/springfox-swagger-ui/**", "anon");
        filterMap.put("/swagger-resources/**", "anon");
        filterMap.put("/v2/api-docs", "anon");
        filterMap.put("/" + props.getModule() + "/druid/**", "anon");
        List<String> filterList = props.getFilters();
        if (filterList != null) {
            for (String filter : filterList) {
                String[] fs = filter.split(":");
                if (fs[1].indexOf("myAuthcSecret") != -1 && !props.isOpenSecret()) continue;
                filterMap.put(fs[0].trim(), fs[1].trim());
            }
        }
        HashMap<String, Object> filters = new HashMap<String, Object>();
        if (props.isOpenSecret()) {
            filters.put("myAuthcSecret", (Object)new AuthcSecretFilter());
            filterMap.put("/" + props.getModule() + props.getLoginUrl(), "myAuthcSecret");
        }
        if (props.isOpenToken()) {
            filters.put("myAuthcToken", (Object)new AuthcTokenFilter(props));
            filterMap.put("/" + props.getModule() + "/**", "myAuthcToken");
        }
        shiroFilter.setFilters(filters);
        shiroFilter.setFilterChainDefinitionMap(filterMap);
        return shiroFilter;
    }

    @Bean(value={"lifecycleBeanPostProcessor"})
    public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator proxyCreator = new DefaultAdvisorAutoProxyCreator();
        proxyCreator.setProxyTargetClass(true);
        return proxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager(securityManager);
        return advisor;
    }
}

