/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.autoconfigure;

import cn.opencodes.framework.autoconfigure.properties.RedissonProperties;
import cn.opencodes.framework.tools.utils.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Config.class})
public class RedissonConfiguration {
    @Bean
    @ConditionalOnProperty(name={"redisson.master-name"})
    RedissonClient redissonSentinel(RedissonProperties redssionProperties) {
        Config config = new Config();
        SentinelServersConfig serverConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().addSentinelAddress(redssionProperties.getSentinelAddresses()).setMasterName(redssionProperties.getMasterName()).setTimeout(redssionProperties.getTimeout())).setMasterConnectionPoolSize(redssionProperties.getMasterConnectionPoolSize())).setSlaveConnectionPoolSize(redssionProperties.getSlaveConnectionPoolSize());
        if (StringUtils.isNotBlank((String)redssionProperties.getPassword())) {
            serverConfig.setPassword(redssionProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnProperty(name={"redisson.address"})
    RedissonClient redissonSingle(RedissonProperties redssionProperties) {
        Config config = new Config();
        SingleServerConfig serverConfig = ((SingleServerConfig)config.useSingleServer().setAddress(redssionProperties.getAddress()).setTimeout(redssionProperties.getTimeout())).setConnectionPoolSize(redssionProperties.getConnectionPoolSize()).setConnectionMinimumIdleSize(redssionProperties.getConnectionMinimumIdleSize());
        if (StringUtils.isNotBlank((String)redssionProperties.getPassword())) {
            serverConfig.setPassword(redssionProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }
}

