/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.autoconfigure;

import cn.opencodes.framework.tools.vo.CoreConst;
import cn.opencodes.framework.tools.vo.R;
import cn.opencodes.framework.tools.vo.RException;
import org.apache.shiro.authz.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RExceptionConfiguration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={TypeMismatchException.class})
    public R<?> requestTypeMismatch(TypeMismatchException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error(CoreConst.HttpStatus.PARAM_ERROR.value(), "\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public R<?> requestMissingServletRequest(MissingServletRequestParameterException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error(CoreConst.HttpStatus.PARAM_ERROR.value(), "\u7f3a\u5931\u53c2\u6570\u9519\u8bef");
    }

    @ExceptionHandler(value={RException.class})
    public R<?> handleRRException(RException e) {
        return R.error(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public R<?> handleDuplicateKeyException(DuplicateKeyException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error(CoreConst.HttpStatus.EXISTS.value(), "\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55");
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public R<?> handleAuthorizationException(AuthorizationException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error(CoreConst.HttpStatus.UNAUTHORIZED.value(), "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @ExceptionHandler(value={Exception.class})
    public R<?> handleException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error(e.getMessage());
    }
}

