/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.autoconfigure;

import cn.opencodes.framework.autoconfigure.properties.AlphaProperties;
import cn.opencodes.framework.core.interceptor.AccessInterceptor;
import cn.opencodes.framework.core.interceptor.MaliciousInterceptor;
import cn.opencodes.framework.core.utils.SpringUtils;
import cn.opencodes.framework.tools.xss.XssFilter;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@DependsOn(value={"springUtils"})
public class MVCAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private AlphaProperties props;
    @Autowired(required=false)
    private MaliciousInterceptor maliciousInterceptor;
    @Autowired(required=false)
    private AccessInterceptor accessInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        Map<String, String> interceptors;
        if (this.accessInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)this.accessInterceptor).addPathPatterns(new String[]{"/" + this.props.getModule() + "/**"});
        }
        if (this.maliciousInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)this.maliciousInterceptor).addPathPatterns(new String[]{"/" + this.props.getModule() + "/**"});
        }
        if ((interceptors = this.props.getInterceptors()) != null) {
            for (String k : interceptors.keySet()) {
                HandlerInterceptorAdapter interceptor = SpringUtils.getBean(k, HandlerInterceptorAdapter.class);
                registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(new String[]{interceptors.get(k)});
            }
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        List<String> resources = this.props.getResources();
        if (resources != null) {
            for (String res : resources) {
                String[] fs = res.split(":");
                registry.addResourceHandler(new String[]{fs[0].trim()}).addResourceLocations(new String[]{fs[1].trim()});
            }
        }
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/" + this.props.getModule() + "/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(0);
        return bean;
    }

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new XssFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("xssFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }
}

