package cn.opencodes.framework.tools.vo;

import io.swagger.annotations.ApiModelProperty;

import java.util.LinkedList;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

/**
 * 继承该类实现树形结构
 * @author HJ
 */
public class TreeNode {

	@ApiModelProperty(value = "ID")
	@JsonSerialize(using=ToStringSerializer.class)
	private Long id;

	@ApiModelProperty(value = "上级ID,一级为0")
	@JsonSerialize(using=ToStringSerializer.class)
	private Long pid;
	
	@ApiModelProperty(value = "子对象")
	private List<Object>  children = new LinkedList<>();
    

    public List<Object> getChildren() {
        return children;
    }

    public void setChildren(List<Object> children) {
        this.children = children;
    }

	public Long getId() {
		return id;
	}

	public Long getPid() {
		return pid;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}
}