package cn.opencodes.framework.tools.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 返回数据
 * @author HJ
 */
public class R<T> implements Serializable{
	private static final long serialVersionUID = 1L;
	private static final String OK = "OK";

	@ApiModelProperty(value = "执行码: 200值成功,其他值失败")
	private int code = CoreConst.HttpStatus.OK.value();
	
	@ApiModelProperty(value = "消息内容")
	private String msg = R.OK;
	
	@ApiModelProperty(value = "响应数据")
	private T data;
	
	
   //**********************构造成功对象*****************************//
	public static R<?> ok(String msg) {
		R<Object> r = new R<Object> ();
		r.msg = msg;
		return r;
	}
	public static R<?> ok() {
		return ok(R.OK);
	}
	
	
  //**********************构造查询返回结果对象*****************************//
	public static <T>R<T> data(String msg, T data) {
		R<T> r = new R<T> ();
		r.msg = msg;
		r.data = data;
		return r;
	}
	public static <T>R<T> data(T data) {
		return data(R.OK, data);
	}
	
	
   //**********************构造失败对象*****************************//	
	public static <T>R<T> error(int code, String msg) {
		R<T> r = new R<T> ();
		r.code = code;
		r.msg = msg;
		return r;
	}
	public static <T>R<T> error(String msg) {
		return error(CoreConst.HttpStatus.ERROR.value(), msg);
	}
	public static R<?> error() {
		return error(CoreConst.HttpStatus.ERROR.value(), "ERROR");
	}
	
	
   //**********************设置成员变量[GET、SET 方法]*****************************//	
	public int getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}
	
}
