package cn.opencodes.framework.tools.vo;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import cn.opencodes.framework.tools.utils.StringUtils;
import cn.opencodes.framework.tools.xss.SQLFilter;

/**
 * 查询参数
 * @author HJ
 */
public class Query extends LinkedHashMap<String, Object> {
	private static final long serialVersionUID = 1L;
	//当前页码
    private int currPage = 1;
    //每页条数
    private int pageSize = 10;
	//排序
	private String orderBy;
	
	
	public Query(Object ...objs){
		Map<String, Object> params = new HashMap<>();
		if (objs != null) {
			for (int i = 0; i < objs.length; i=i+2) {
				params.put(objs[i].toString(), objs[i+1]);
			}
			processForMap(params);
		}
	}

    public Query(Map<String, Object> params){
    	processForMap(params);
    }

	private void processForMap(Map<String, Object> params) {
		//没有值不做处理
		if (params==null || params.size()<1) {
			return;
		}
		//获取字符串两边空格
    	for (Map.Entry<String, Object> e : params.entrySet()) {
    		if (e.getValue() != null && e.getValue() instanceof String) {
    			this.put(e.getKey(), e.getValue().toString().trim());
			}else {
				this.put(e.getKey(), e.getValue());
			}
		}
    	//设置分页参数
        this.currPage = getInt(params.get("currPage"), this.currPage);
        this.pageSize = getInt(params.get("pageSize"), this.pageSize);
        this.orderBy = (String)params.get("orderBy");
        //处理分页参数
        this.put("pageStart", (currPage - 1) * pageSize);
        this.put("pageSize", pageSize);
        //处理排序参数，防止SQL注入（因为orderBy是通过拼接SQL实现排序的，会有SQL注入风险）
        if(StringUtils.isNotBlank(this.orderBy)){
        	this.orderBy = SQLFilter.sqlInject(this.orderBy);
            this.put("orderBy", this.orderBy);
        }else {
        	this.orderBy = null;
		}
	}

    
    public Query put(String key, Object value) {
		//防止排序注入
		if (key.equals("orderBy") && value!=null && StringUtils.isNotBlank(value.toString())) {
			value = SQLFilter.sqlInject(value.toString());
		}
		super.put(key, value);
		return this;
	}
    
    public int getCurrPage() {
        return currPage;
    }

    public void setCurrPage(int currPage) {
        this.currPage = currPage;
    }

    public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	
    private int getInt(Object param, int defalut){
    	int v = defalut;
    	try {
    		if (param != null) {
    			v = Integer.parseInt(param.toString());
    		}
		} catch (Exception e) {
		}
    	return v;
    }

	public String getOrderBy() {
		return orderBy;
	}

	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}

}
