package cn.opencodes.framework.tools.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 分页工具类
 * @author HJ
 */
@ApiModel(value = "分页对象")
public class PageBean<T> implements Serializable {
	private static final long serialVersionUID = 5220366413467086022L;
	//总记录数
	@ApiModelProperty(value = "总记录数")
	private long total;
	//每页记录数
	@ApiModelProperty(value = "每页记录数")
	private int pageSize;
	//总页数
	@ApiModelProperty(value = "总页数")
	private int totalPage;
	//当前页数
	@ApiModelProperty(value = "当前页数")
	private int currPage;
	//列表数据
	@ApiModelProperty(value = "列表数据")
	private List<T> list;
	
	/**
	 * 分页
	 * @param list        列表数据
	 * @param total  总记录数
	 * @param pageSize    每页记录数
	 * @param currPage    当前页数
	 */
	public PageBean(List<T> list, long total, int currPage, int pageSize) {
		this.list = list;
		this.total = total;
		this.pageSize = pageSize;
		this.currPage = currPage;
		this.totalPage = (int)Math.ceil((double)total/pageSize);
	}

	public long getTotal() {
		return total;
	}

	public void setTotal(long totalCount) {
		this.total = totalCount;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public int getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(int totalPage) {
		this.totalPage = totalPage;
	}

	public int getCurrPage() {
		return currPage;
	}

	public void setCurrPage(int currPage) {
		this.currPage = currPage;
	}

	public List<T> getList() {
		return list;
	}

	public void setList(List<T> list) {
		this.list = list;
	}
	
}
