package cn.opencodes.framework.tools.vo;

import java.text.DecimalFormat;
import java.util.Calendar;

/**
 * 常量
 * @author HJ
 */
public class CoreConst {
	/** 超级管理员ID */
	public static final int SUPER_ADMIN = 1;
	public final static String APPLICATION_JSON_VALUE = "application/json";
	public static final String CONTENT_TYPE = "Content-Type";
	
	
	/**
	 * 生成表名称:logs_2019_09 
	 * @param tableName 生成表名称logs_2019_09 
	 * @param offset
	*/
	public static String generateTableName(String tableName, int offset){
		Calendar c = Calendar.getInstance();
		// 2013
		int year = c.get(Calendar.YEAR);
		// 0 -11
		int month = c.get(Calendar.MONTH) + 1 + offset;
		
		if(month > 12){
			year ++ ;
			month = month - 12 ;
		}
		if(month < 1){
			year -- ;
			month = month + 12 ;
		}
		DecimalFormat df = new DecimalFormat();
		df.applyPattern("00");
		return tableName+"_" + year + "_" + df.format(month) ;
	}
	
	/**
	 * 获取创建动态表sql(按月份创建)
	 * @param tableName 生成表名称logs_2019_09 
	 * @param offset 月份偏移量 
	 */
	public static String getCreateTableSQL(String tableName, int offset){
		String dynTabName = generateTableName(tableName, offset);
		StringBuffer sql = new StringBuffer();
		sql.append("create table ")
		   .append(" if not exists ").append(dynTabName)
		   .append(" like ").append(tableName);
		return sql.toString();
	}
	
	
	/**
	 * 服务响应状态
	 */
	public enum HttpStatus {
		/**
		 * 参数为空或错误：-1
		 */
		PARAM_BLANK(-1),
		/**
		 * 失败：0
		 */
		FAILURE(0),
		/**
		 * 成功：200
		 */
		OK(200),
		/**
		 * 参数错误：400
		 */
		PARAM_ERROR(400),
		/**
		 * 用户失效或秘钥错误：401
		 */
		TOKEN_EXPIRED(401),
		/**
		 * 未授权：403
		 */
		UNAUTHORIZED(403),
		/**
		 * 异常错误：500
		 */
		ERROR(500),
		/**
		 * 数据已存在：501
		 */
		EXISTS(501);

		private int value;

		HttpStatus(int value) {
			this.value = value;
		}

		public int value() {
			return value;
		}
	}
}
