package cn.opencodes.framework.tools.utils;

import java.util.LinkedList;
import java.util.List;

import cn.opencodes.framework.tools.utils.BeanUtils;
import cn.opencodes.framework.tools.vo.TreeNode;

/**
 * 树形结构工具类
 * @author HJ
 */
public class TreeUtils {

	/**
	 * 根据pid构建树节点, pid从0开始遍历
	 * @param classz 返回类型
	 * @param srcList 源数据需继承TreeNode
	 * @return 树形菜单结构
	 */
	public static <T extends TreeNode>List<T> build(Class<T> classz, List<? extends TreeNode> srcList) {
        List<T> treeList = new LinkedList<>();
        Long menuId = 0L;
        for(TreeNode n : srcList) {
            if (menuId.equals( n.getPid() )) {
                treeList.add(
                	findChildren(classz, srcList, n)
                );
            }
        }
        return treeList;
    }
	
	/*
     * 查找子节点
     */
    private static <T extends TreeNode> T findChildren(Class<T> classz, List<? extends TreeNode> srcList, TreeNode node) {
    	try {
    		T treeNode = classz.newInstance();
        	BeanUtils.copyBean2Bean(treeNode, node);
            for(TreeNode n : srcList) {
                if(node.getId().equals( n.getPid() )) {
                	treeNode.getChildren().add(
                		findChildren(classz, srcList, n)
                	);
                }
            }
            return treeNode;
		} catch (Exception e) {
			e.printStackTrace();
		}
    	return null;
    }

}