package cn.opencodes.framework.tools.utils;
import java.util.Base64;
import java.util.Random;
import java.util.UUID;

import org.apache.commons.lang.RandomStringUtils;  
  
/** 
 * 各种id生成策略 
 * @author hj
 */  
public class IDUtils {  
	
	/**
	 * 随机生成指定长度字符串
	 * @param len
	 */
	public static String randomBuildString(int len){
		return RandomStringUtils.randomAlphanumeric(len);
	}
    /** 
     * 图片名生成 
     */  
    public static String genImageName() {  
        //取当前时间的长整形值包含毫秒  
        long millis = System.currentTimeMillis();  
        //加上三位随机数  
        Random random = new Random();  
        int end3 = random.nextInt(999);  
        //如果不足三位前面补0  
        String str = millis + String.format("%03d", end3);  
        return str;  
    }  
    /**
     * 流水号日期生成规则
     * @param prefix 前缀
     * @param fmt	 ymdhMs
     * @param no	  自增序号
     * @param len	 长度
     */
    public static String buildDateLineNo(String prefix, String fmt, long no, int len) {
		StringBuilder sb = new StringBuilder(prefix);
		char[] cs = fmt.toCharArray();
		for (char c : cs) {
			switch (c) {
			case 'y':
				sb.append("%1$tY");
				break;
			case 'm':
				sb.append("%1$tm");
				break;
			case 'd':
				sb.append("%1$td");
				break;
			case 'h':
				sb.append("%1$tk");
				break;
			case 'M':
				sb.append("%1$tM");
				break;
			case 's':
				sb.append("%1$tS");
				break;
			}
		}
		sb.append("%2$0").append(len).append("d");
		return String.format(sb.toString(), System.currentTimeMillis(), no);
	}
	/**
	 * base64加密
	 * @param content
	 */
	public static String base64Encoder(String content){
		return Base64.getEncoder().encodeToString(content.getBytes());
	}
	/**
	 * base64解密
	 * @param src
	 */
	public static String base64Decoder(String src){
		return new String(Base64.getDecoder().decode(src));
	}
	/**
	 * UUID 去掉-
	 */
	public static String guid() {  
		 return UUID.randomUUID().toString().replace("-", "");  
	} 
	
}  