package cn.opencodes.framework.tools.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日期处理
 * 
 * @author HJ
 */
public class DateUtils extends org.apache.commons.lang.time.DateUtils{
	/** 时间格式(yyyy-MM-dd) */
	public final static String DATE_PATTERN = "yyyy-MM-dd";
	/** 时间格式(yyyy-MM-dd HH:mm:ss) */
	public final static String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
	/** 时间格式(yyyyMMddhhmmss) */
	public final static String DATE_LONG_PATTERN = "yyyyMMddhhmmss";
	
	public static String format(Date date) {
        return format(date, DATE_PATTERN);
    }

	/**
	 * 日期对象转字符串
	 * @param date
	 * @param pattern
	 */
    public static String format(Date date, String pattern) {
        if(date != null){
            return new SimpleDateFormat(pattern).format(date);
        }
        return null;
    }
    
	
	/**
	 * 字符串转日期对象
	 * @param pattern
	 * @param date
	 * @throws Exception
	 */
	public static Date parse(String pattern, String date) throws Exception{
		if(StringUtils.isEmpty(date)){
			return null;
		}
		return new SimpleDateFormat(pattern).parse(date);
	}
	
	/** 时间格式(yyyy-MM-dd) */
	public static Date parseToDay(String date) throws Exception{
		if(StringUtils.isEmpty(date)){
			return null;
		}
		return new SimpleDateFormat(DATE_PATTERN).parse(date);
	}
	
	/** 时间格式(yyyy-MM-dd HH:mm:ss) */
	public static Date parseToSecond(String date) throws Exception{
		if(StringUtils.isEmpty(date)){
			return null;
		}
		return new SimpleDateFormat(DATE_TIME_PATTERN).parse(date);
	}
	
	/** 时间格式(yyyyMMddhhmmss) */
	public static String formatNowLong()throws Exception{
		Date date = new Date();
		return format(date, DATE_LONG_PATTERN);
	}
	
	/** 时间格式(yyyy-MM-dd) */
	public static String formatNowDay()throws Exception{
		Date date = new Date();
		return format(date, DATE_PATTERN);
	}
	
	/** 时间格式(yyyy-MM-dd HH:mm:ss) */
	public static String formatNowSecond()throws Exception{
		Date date = new Date();
		return format(date, DATE_TIME_PATTERN);
	}
}
