package cn.opencodes.framework.tools.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayUtils extends org.apache.commons.lang.ArrayUtils{
	
	/**
	 * 字符串转list
	 * @param a 字符串
	 * @param regex 分隔符
	 */
	@SuppressWarnings("unchecked")
	public static <T>List<T> asList(String a, String regex){
		if (StringUtils.isNotBlank(a)) {
			List<T> list = new java.util.ArrayList<>();
			String[] arry = a.trim().split(regex);
			for (String s : arry) {
				list.add( (T)s );
			}
			return list;
		}
		return null;
	}
	
	/**
	 * 字符串转list --- 默认逗号分隔
	 * @param a
	 */
	public static <T>List<T> asList(String a){
		return asList(a, ",");
	}
	
	/**
	 * 如果提供的集合为{@code null}，返回一个不可变的默认空集合，否则返回原集合<br>
	 * 空集合使用{@link Collections#emptySet()}
	 *
	 * @param <T> 集合元素类型
	 * @param set 提供的集合，可能为null
	 * @return 原集合，若为null返回空集合
	 */
	public static <T> Set<T> emptyIfNull(Set<T> set) {
		return (null == set) ? Collections.emptySet() : set;
	}
	/**
	 * 新建Set集合
	 * @return 返回一个空Set
	 */
	public static <T> Set<T> newSet() {
		return Collections.emptySet();
	}

	/**
	 * 如果提供的集合为{@code null}，返回一个不可变的默认空集合，否则返回原集合<br>
	 * 空集合使用{@link Collections#emptyList()}
	 *
	 * @param <T> 集合元素类型
	 * @param set 提供的集合，可能为null
	 * @return 原集合，若为null返回空集合
	 */
	public static <T> List<T> emptyIfNull(List<T> list) {
		return (null == list) ? Collections.emptyList() : list;
	}
	
	/**
	 * 新建List集合
	 * @return 返回一个空List
	 */
	public static <T> List<T> newList(){
		return Collections.emptyList();
	}
	
	/**
	 * 判断指定集合是否包含指定值，如果集合为空（null或者空），返回{@code false}，否则找到元素返回{@code true}
	 *
	 * @param collection 集合
	 * @param value      需要查找的值
	 * @return 如果集合为空（null或者空），返回{@code false}，否则找到元素返回{@code true}
	 */
	public static boolean contains(Collection<?> collection, Object value) {
		return isNotEmpty(collection) && collection.contains(value);
	}
	
	/**
	 * 根据集合返回一个元素计数的 {@link Map}<br>
	 * 所谓元素计数就是假如这个集合中某个元素出现了n次，那将这个元素做为key，n做为value<br>
	 * 例如：[a,b,c,c,c] 得到：<br>
	 * a: 1<br>
	 * b: 1<br>
	 * c: 3<br>
	 * 
	 * @param <T> 集合元素类型
	 * @param iter {@link Iterator}，如果为null返回一个空的Map
	 * @return {@link Map}
	 */
	public static <T> Map<T, Integer> countElement(Iterator<T> iter) {
		final HashMap<T, Integer> countMap = new HashMap<>();
		if (null != iter) {
			Integer count;
			T t;
			while (iter.hasNext()) {
				t = iter.next();
				count = countMap.get(t);
				if (null == count) {
					countMap.put(t, 1);
				} else {
					countMap.put(t, count + 1);
				}
			}
		}
		return countMap;
	}
	
	/**
	 * 集合是否为空
	 * @param collection 集合
	 * @return 是否为空
	 */
	public static boolean isEmpty(Collection<?> collection) {
		return collection == null || collection.isEmpty();
	}
	
	/**
	 * 集合是否为非空
	 * @param collection 集合
	 * @return 是否为非空
	 */
	public static boolean isNotEmpty(Collection<?> collection) {
		return false == isEmpty(collection);
	}
	
	/**
	 * 是否包含{@code null}元素
	 * @param iter 被检查的{@link Iterator}对象，如果为{@code null} 返回false
	 * @return 是否包含{@code null}元素
	 */
	public static boolean hasNull(Iterator<?> iter) {
		if (null == iter) {
			return true;
		}
		while (iter.hasNext()) {
			if (null == iter.next()) {
				return true;
			}
		}
		return false;
	}
	
}
