package cn.opencodes.framework.tools.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import cn.opencodes.framework.tools.utils.StringUtils;

/**
 * 邮件发送器
 * @author HJ
 */
public class MailSenderUtils {
	/**
	 * 发送普通邮件
	 * @param toMail 收信人地址
	 * @param csMail 抄送人地址 多个抄送人 时，用逗号隔开
	 * @param subject email主题
	 * @param message 发送email信息  
	 * @throws UnsupportedEncodingException 
	 */
	public static void send(String toMail, String csMail, String subject, String message, 
			String username,String password,String host, int smtpPort, String from, String charSet) 
			throws AddressException, MessagingException, UnsupportedEncodingException {
		//1、连接邮件服务器的参数配置
        Properties props = new Properties();
        //设置用户的认证方式
        props.setProperty("mail.smtp.auth", "true");
        //设置传输协议
        props.setProperty("mail.transport.protocol", "smtp");
        //设置发件人的SMTP服务器地址
        //props.setProperty("mail.smtp.host", "smtp.163.com");
        //2、创建定义整个应用程序所需的环境信息的 Session 对象
        Session session = Session.getInstance(props);
        //设置调试信息在控制台打印出来
        //session.setDebug(true);
        //3、创建邮件的实例对象
        //创建一封邮件的实例对象
        MimeMessage msg = new MimeMessage(session);
        //设置发件人地址
        msg.setFrom(new InternetAddress(from));
        /*
         * 设置收件人地址（可以增加多个收件人、抄送、密送），即下面这一行代码书写多行
         * MimeMessage.RecipientType.TO:发送
         * MimeMessage.RecipientType.CC：抄送多个抄送人时，用逗号隔开
         * MimeMessage.RecipientType.BCC：密送
         */
        msg.setRecipient(MimeMessage.RecipientType.TO, new InternetAddress(toMail));
  		if (StringUtils.isNotEmpty(csMail)) {
  			msg.setRecipients(Message.RecipientType.CC, InternetAddress.parse(csMail)); 
  		}
        //设置邮件主题
        msg.setSubject(subject, charSet);
        //设置邮件正文
        msg.setContent(message, "text/html;charset=UTF-8");
        //设置邮件的发送时间,默认立即发送
        msg.setSentDate(new Date());
        //4、根据session对象获取邮件传输对象Transport
        Transport transport = session.getTransport();
        //设置发件人的账户名和密码
        transport.connect(host, smtpPort, username, password);
        //发送邮件，并发送到所有收件人地址，message.getAllRecipients() 获取到的是在创建邮件对象时添加的所有收件人, 抄送人, 密送人
        transport.sendMessage(msg, msg.getAllRecipients());
        //如果只想发送给指定的人，可以如下写法
        //transport.sendMessage(msg, new Address[]{new InternetAddress("xxx@qq.com")});
        //5、关闭邮件连接
        transport.close();
	}
	
	/**
	 * 发送邮件(含附件)
	 * @param toMail 收信人地址
	 * @param csMail 抄送人地址 多个抄送人 时，用逗号隔开
	 * @param subject email主题
	 * @param message 发送email信息  
	 * @throws UnsupportedEncodingException 
	 */
	public static void sendForFile(String toMail, String csMail, String subject, String message, String[] files,
			String username,String password,String host, int smtpPort, String from, String charSet) 
			throws AddressException, MessagingException, UnsupportedEncodingException {
		//1、连接邮件服务器的参数配置
        Properties props = new Properties();
        //设置用户的认证方式
        props.setProperty("mail.smtp.auth", "true");
        //设置传输协议
        props.setProperty("mail.transport.protocol", "smtp");
        //设置发件人的SMTP服务器地址
        //props.setProperty("mail.smtp.host", "smtp.163.com");
        //2、创建定义整个应用程序所需的环境信息的 Session 对象
        Session session = Session.getInstance(props);
        //设置调试信息在控制台打印出来
        //session.setDebug(true);
        //3、创建邮件的实例对象
        //创建一封邮件的实例对象
        MimeMessage msg = new MimeMessage(session);
        //设置发件人地址
        msg.setFrom(new InternetAddress(from));
        /*
         * 设置收件人地址（可以增加多个收件人、抄送、密送），即下面这一行代码书写多行
         * MimeMessage.RecipientType.TO:发送
         * MimeMessage.RecipientType.CC：抄送多个抄送人时，用逗号隔开
         * MimeMessage.RecipientType.BCC：密送
         */
        msg.setRecipient(MimeMessage.RecipientType.TO, new InternetAddress(toMail));
  		if (StringUtils.isNotEmpty(csMail)) {
  			msg.setRecipients(Message.RecipientType.CC, InternetAddress.parse(csMail)); 
  		}
        //设置邮件主题
        msg.setSubject(subject, charSet);
        //新建一个MimeMultipart对象来存放多个BodyPart 对象
        Multipart mul = new MimeMultipart(); 
        //新建一个存放信件内容的BodyPart对象
		BodyPart mdp = new MimeBodyPart(); 
		mdp.setContent(message,"text/html;charset=UTF-8");
		mul.addBodyPart(mdp); 
		//设置信件的附件（用本机上的文件作为附件）
		for (String path : files) {
			mdp = new MimeBodyPart();
			DataHandler dh = new DataHandler(new FileDataSource(path));
			mdp.setDataHandler(dh);
			mdp.setFileName(MimeUtility.encodeText(dh.getName()));
			mul.addBodyPart(mdp);
		}
		//作为邮件的内容添加到邮件对象
		msg.setContent(mul);
        //设置邮件的发送时间,默认立即发送
        msg.setSentDate(new Date());
        //4、根据session对象获取邮件传输对象Transport
        Transport transport = session.getTransport();
        //设置发件人的账户名和密码
        transport.connect(host, smtpPort, username, password);
        //发送邮件，并发送到所有收件人地址，message.getAllRecipients() 获取到的是在创建邮件对象时添加的所有收件人, 抄送人, 密送人
        transport.sendMessage(msg, msg.getAllRecipients());
        //如果只想发送给指定的人，可以如下写法
        //transport.sendMessage(msg, new Address[]{new InternetAddress("xxx@qq.com")});
        //5、关闭邮件连接
        transport.close();
	}
}
