package cn.opencodes.framework.tools.mail;

import java.io.IOException;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

/**
 * 邮件接收器
 * @author HJ
 */
public class MailRecipientUtils {
	
	public static void recipient(String username,String password,String host, int port) throws MessagingException, IOException{
		 //1、连接邮件服务器的参数配置
        Properties props = new Properties();
        //设置传输协议
        props.setProperty("mail.store.protocol", "pop3");
        //设置收件人的POP3服务器
        //props.setProperty("mail.pop3.host", "pop3.163.com");
        //2、创建定义整个应用程序所需的环境信息的 Session 对象
        Session session = Session.getInstance(props);
        //设置调试信息在控制台打印出来
        //session.setDebug(true);
        Store store = session.getStore("pop3");
        //连接收件人POP3服务器
        store.connect(host, port, username, password);
        //获得用户的邮件账户，注意通过pop3协议获取某个邮件夹的名称只能为inbox
        Folder folder = store.getFolder("inbox");
        //设置对邮件账户的访问权限
        folder.open(Folder.READ_WRITE);
         
        //得到邮件账户的所有邮件信息
        Message [] messages = folder.getMessages();
        for(int i = 0 ; i < messages.length ; i++){
            //获得邮件主题
            String subject = messages[i].getSubject();
            System.out.println(MimeUtility.decodeText(subject));
            //获得邮件发件人
            Address[] from = messages[i].getFrom();
            System.out.println(MimeUtility.decodeText(from[0].toString()));
            //获取邮件内容(包含邮件内容的html代码)
            if (messages[i].getContent() instanceof MimeMultipart) {
            	MimeMultipart mul = (MimeMultipart)messages[i].getContent();
            	BodyPart bodyPart = mul.getBodyPart(0);
            	System.out.println(bodyPart.getFileName());
			}else {
				String content = (String) messages[i].getContent();
				System.out.println(content);
			}
        }
        //关闭邮件夹对象
        folder.close(true);
        //关闭连接对象
        store.close();
	}
}
