package cn.opencodes.framework.tools.mail;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.internet.MimeUtility;

import cn.opencodes.framework.tools.utils.StringUtils;

/**
 * 发件人信息配置
 */
public class EmailSenderConfig{
	  private String from;
	  private String fromNick;
	  private String charSet;
	  private String username;
	  private String password;
	  private String host;
	  private String smtpPort;
	  
	  private Map<String, String> hostMap = new HashMap<>();
	  
	  public EmailSenderConfig(String from, String fromNick, String userName, String password, String charSet, String host, String smtpPort){
		  this.from = from;
		  this.fromNick = fromNick;
		  this.charSet =  charSet;
		  this.username = userName;
		  this.password = password;
		  this.host = host;
		  this.smtpPort = smtpPort;
		  initHost();
	  }
	  
	  private void initHost(){
			// 126
			hostMap.put("smtp.126", "smtp.126.com");
			// qq
			hostMap.put("smtp.qq", "smtp.qq.com");

			// 163
			hostMap.put("smtp.163", "smtp.163.com");

			// sina
			hostMap.put("smtp.sina", "smtp.sina.com.cn");

			// tom
			hostMap.put("smtp.tom", "smtp.tom.com");

			// 263
			hostMap.put("smtp.263", "smtp.263.net");

			// yahoo
			hostMap.put("smtp.yahoo", "smtp.mail.yahoo.com");

			// hotmail
			hostMap.put("smtp.hotmail", "smtp.live.com");

			// gmail
			hostMap.put("smtp.gmail", "smtp.gmail.com");
			hostMap.put("smtp.port.gmail", "465");
		}

	public String getFrom() {
		if (StringUtils.isBlank(from)) {
			from = username;
		}
		return from;
	}

	public String getFromNick() {
		if (StringUtils.isBlank(fromNick)) {
			fromNick = getFrom();
		}else {
			try {
				fromNick = MimeUtility.encodeText(fromNick)+"<"+getFrom()+">";
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
				fromNick = from;
			}
		}
		return fromNick;
	}

	public String getCharSet() {
		return charSet;
	}

	public String getUsername() {
		return username;
	}

	public String getPassword() {
		return password;
	}

	public void setFrom(String from) {
		this.from = from;
	}

	public void setFromNick(String fromNick) {
		this.fromNick = fromNick;
	}

	public void setCharSet(String charSet) {
		this.charSet = charSet;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getHost() {
		if (StringUtils.isNotBlank(host)) {
			return host.replace("pop3", "smtp");
		}
		Pattern pattern = Pattern.compile("\\w+@(\\w+)(\\.\\w+){1,2}");
		Matcher matcher = pattern.matcher(getFrom());
		String key = "unSupportEmail";
		if (matcher.find()) {
			key = "smtp." + matcher.group(1);
		}
		if (hostMap.containsKey(key)) {
			return hostMap.get(key);
		} else {
			throw new RuntimeException("unSupportEmail");
		}
	}

	public int getSmtpPort() {
		if (StringUtils.isBlank(smtpPort)) {
			Pattern pattern = Pattern.compile("\\w+@(\\w+)(\\.\\w+){1,2}");
			Matcher matcher = pattern.matcher(getFrom());
			String key = "unSupportEmail";
			if (matcher.find()) {
				key = "smtp.port." + matcher.group(1);
			}
			if (hostMap.containsKey(key)) {
				return Integer.parseInt(hostMap.get(key));
			}
		}
		return 25;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public void setSmtpPort(String smtpPort) {
		this.smtpPort = smtpPort;
	}
	  
}