package cn.opencodes.framework.tools.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
/**
 * 邮箱调用入口
 * @author hj
 */
public class EmailManager{
	private EmailSenderConfig esc;
	
	public EmailManager(EmailSenderConfig esConfig){
		this.esc = esConfig;
	}
	
	/**
	 * @param params 发送方配置
	 * 0-userName|1-password|2-host|3-from|4-fromNick|5-smtpPort|6-charSet </br>
	 * 创建发送邮件服务：0-1时必填参数, 2-5(非必填参数)
	 */
	public static EmailManager getInstance(String ... params){
		String charSet = "UTF-8";
		String userName = null;
		String password = null;
		String host = null;
		String from = null;
		String fromNick = null;
		String smtpPort = null;
		for (int i = 0; i < params.length; i++) {
			if (i == 0) {
				userName = params[0];
			}else if (i == 1) {
				password = params[1];
			}else if (i == 2) {
				host = params[2];
			}else if (i == 3) {
				from = params[3];
			}else if (i == 4) {
				fromNick = params[4];
			}else if (i == 5) {
				smtpPort = params[5];
			}else if (i == 6) {
				charSet = params[6];
			}
		}
		return new EmailManager(
			new EmailSenderConfig(from, fromNick, userName, password, charSet, host, smtpPort)
		);
	}
	
	/**
	 * 发送普通邮件
	 * @param toMail 收信人地址
	 * @param csMail 抄送人地址 多个抄送人 时，用逗号隔开
	 * @param subject email主题
	 * @param message 发送email信息  
	 */
	public void send(String toMail, String csMail, String subject, String message) 
				throws AddressException, MessagingException, UnsupportedEncodingException {
		
		MailSenderUtils.send(toMail, csMail, subject, message, 
				esc.getUsername(), esc.getPassword(), esc.getHost(), esc.getSmtpPort(), esc.getFromNick(), esc.getCharSet());
	}
	
	/**
	 * 发送普通邮件
	 * @param toMail 收信人地址
	 * @param subject email主题
	 * @param message 发送email信息  
	 */
	public void send(String toMail,  String subject, String message) 
			throws AddressException, UnsupportedEncodingException, MessagingException {
		send(toMail, null, subject, message);
	}
	
	
	/**
	 * 发送邮件(含附件)
	 * @param toMail 收信人地址
	 * @param csMail 抄送人地址 多个抄送人 时，用逗号隔开
	 * @param subject email主题
	 * @param message 发送email信息  
	 */
	public void sendForFile(String toMail, String csMail, String subject, String message, String[] files) 
				throws AddressException, MessagingException, UnsupportedEncodingException {
		
		MailSenderUtils.sendForFile(toMail, csMail, subject, message, files, 
				esc.getUsername(), esc.getPassword(), esc.getHost(), esc.getSmtpPort(), esc.getFromNick(), esc.getCharSet());
	}
	
	/**
	 * 发送邮件(含附件)
	 * @param toMail 收信人地址
	 * @param subject email主题
	 * @param message 发送email信息  
	 */
	public void sendForFile(String toMail, String subject, String message, String[] files) 
			throws AddressException, UnsupportedEncodingException, MessagingException {
		sendForFile(toMail, null, subject, message, files);
	}
	
	/**
	 * 接收邮件-默认采用发送方：帐号、密码、服务地址、端口
	 */
	public void recipient() throws MessagingException, IOException{
		MailRecipientUtils.recipient(esc.getUsername(), esc.getPassword(), esc.getHost().replace("smtp", "pop3"), 110);
	}
	
	/**
	 * 接收邮件-默认采用发送方：帐号、密码
	 * @param host 服务器地址
	 * @param port 服务器端口
	 */
	public void recipient(String host, int port) throws MessagingException, IOException{
		MailRecipientUtils.recipient(esc.getUsername(), esc.getPassword(), host, port);
	}
	
	/**
	 * 接收邮件-默认采用发送方：服务地址、端口
	 * @param username 接收人帐号
	 * @param password 接收人密码
	 */
	public void recipient(String username,String password) throws MessagingException, IOException{
		MailRecipientUtils.recipient(username, password, esc.getHost().replace("smtp", "pop3"), 110);
	}
	
	/**
	 * 接收邮件-采用默认端口110
	 * @param username 接收人帐号
	 * @param password 接收人密码
	 * @param host 服务器地址
	 */
	public void recipient(String username,String password,String host) throws MessagingException, IOException{
		MailRecipientUtils.recipient(username, password, host, 110);
	}
	
	/**
	 * 接收邮件
	 * @param username 接收人帐号
	 * @param password 接收人密码
	 * @param host 服务器地址
	 * @param port 服务器端口
	 */
	public void recipient(String username,String password,String host, int port) throws MessagingException, IOException{
		MailRecipientUtils.recipient(username, password, host, port);
	}
	
	
	/*public static void main(String[] args) throws Exception {
		EmailManager em = EmailManager
			.getInstance("账号", "密码", "smtp.263.net");
		
		//普通邮件发送
		em.send("接收人邮箱", "接收人邮箱", "邮件主题测试!", "我就是测试一下");
		
		//附件邮件发送
		String[] files = {"D:\\logs\\日志.txt","D:\\logs\\日志.txt","D:\\logs\\日志.txt"};
		em.sendForFile("接收人邮箱", "接收人邮箱", "邮件(附件)主题测试!", "我就是测试一下含附件的邮件", files);
		
		//接收邮件
		em.recipient("收件人邮箱", "");
	}*/
	
}