package cn.opencodes.framework.core.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * 全局用户对象
 * @author HJ
 */
@ApiModel(value = "登录用户")
public class UserRoot implements Serializable{
	private static final long serialVersionUID = -982329279295582691L;
	
	@ApiModelProperty(value = "用户ID")
	private long id;
	
	@ApiModelProperty(value = "用户名")
	private String username;
	
	@ApiModelProperty(value = "超级管理员 0:否 1:是")
	private Integer superAdmin;
	
	@ApiModelProperty(value = "用户状态 0:禁用 1:正常")
	private int status;
	
	@ApiModelProperty(value = "用户踢线 true:是 false:否")
	private boolean kickout = false;
	
	@ApiModelProperty(value = "拓展属性")
	private Map<String,Object> prop = new HashMap<>();
	
	
	public void set(String key, Object value){
		prop.put(key, value);
	}
	
	public <T>T get(String key, Class<T> cls){
		@SuppressWarnings("unchecked")
		T t = (T)prop.get(key);
		return t;
	}
	
	public <T>List<T> getList(String key, Class<T> cls){
		@SuppressWarnings("unchecked")
		List<T> list = (List<T>) prop.get(key);
		return list;
	}
	
	public long getId() {
		return id;
	}
	
	/**
	 * 用户账号
	 */
	public String getUsername() {
		return username;
	}
	/**
	 * 状态  0：禁用   1：正常
	 */
	public int getStatus() {
		return status;
	}
	
	public void setId(long id) {
		this.id = id;
	}
	public void setUsername(String username) {
		this.username = username;
	}
	public void setStatus(int status) {
		this.status = status;
	}

	public Map<String, Object> getProp() {
		return prop;
	}

	public void setProp(Map<String, Object> prop) {
		this.prop = prop;
	}


	public boolean isKickout() {
		return kickout;
	}

	public void setKickout(boolean kickout) {
		this.kickout = kickout;
	}

	public Integer getSuperAdmin() {
		return superAdmin;
	}

	public void setSuperAdmin(Integer superAdmin) {
		this.superAdmin = superAdmin;
	}

}
