package cn.opencodes.framework.core.vo;

import java.io.Serializable;
import java.util.Date;
/**
 * 流水号配置
 * @author hj
 */
public class SerialNoConfig implements Serializable{
	private static final long serialVersionUID = -4924515932100881229L;
	
	//主键
	private Long id;
	//当前已使用到的流水号自增长值 
	private int no;
	//当前流水号
	private int currentNo;
	//流水号自增步长，每次缓存多少
	private Integer step;
	//流水号自增长最大值
	private int maxNo;
	//流水号业务代码
	private String code;
	//流水号前缀
	private String prefix;
	//日期格式
	private String fmt;
	//流水号自增达到最大是否覆盖为初始值：0否、1是
	private int override;
	//更新日期
	private Date utime;
	
	
	public Long getId() {
		return id;
	}
	public int getNo() {
		return no;
	}
	public Integer getStep() {
		return step;
	}
	public String getCode() {
		return code;
	}
	public String getFmt() {
		return fmt;
	}
	public Date getUtime() {
		return utime;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public void setNo(int no) {
		this.no = no;
	}
	public void setStep(Integer step) {
		this.step = step;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public void setFmt(String fmt) {
		this.fmt = fmt;
	}
	public void setUtime(Date utime) {
		this.utime = utime;
	}
	public int getMaxNo() {
		return maxNo;
	}
	public void setMaxNo(int maxNo) {
		this.maxNo = maxNo;
	}
	public int getOverride() {
		return override;
	}
	public void setOverride(int override) {
		this.override = override;
	}
	public String getPrefix() {
		return prefix;
	}
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}
	public int getCurrentNo() {
		return currentNo;
	}
	public void setCurrentNo(int currentNo) {
		this.currentNo += currentNo;
	}
	
}
