package cn.opencodes.framework.core.vo;

import java.io.Serializable;
import java.util.Date;
/**
 * 操作日志对象
 * @author HJ
 */
public class OperationLog implements Serializable{
	private static final long serialVersionUID = 7885479005938635338L;
	
	private Long id;
	//用户名
	private String username;
	//操作描述
	private String operation;
	//请求方法
	private String method;
	//请求参数
	private String params;
	//执行时长(毫秒)
	private Long time;
	//创建时间
	private Date createDate;
	//执行状态
	private int execState;
	//错误信息
	private String errMsg;

	/**
	 * 设置：
	 */
	public void setId(Long id) {
		this.id = id;
	}
	/**
	 * 获取：
	 */
	public Long getId() {
		return id;
	}
	/**
	 * 设置：用户名
	 */
	public void setUsername(String username) {
		this.username = username;
	}
	/**
	 * 获取：用户名
	 */
	public String getUsername() {
		return username;
	}
	/**
	 * 设置：用户操作
	 */
	public void setOperation(String operation) {
		this.operation = operation;
	}
	/**
	 * 获取：用户操作
	 */
	public String getOperation() {
		return operation;
	}
	/**
	 * 设置：请求方法
	 */
	public void setMethod(String method) {
		this.method = method;
	}
	/**
	 * 获取：请求方法
	 */
	public String getMethod() {
		return method;
	}
	/**
	 * 设置：请求参数
	 */
	public void setParams(String params) {
		this.params = params;
	}
	/**
	 * 获取：请求参数
	 */
	public String getParams() {
		if (params != null) {
			params = (params.length()>255 ? params.substring(0,255) : params);
		}
		return params;
	}
	/**
	 * 设置：创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 * 获取：创建时间
	 */
	public Date getCreateDate() {
		return createDate;
	}

	public Long getTime() {
		return time;
	}

	public void setTime(Long time) {
		this.time = time;
	}
	public int getExecState() {
		return execState;
	}
	public String getErrMsg() {
		return errMsg;
	}
	public void setExecState(int execState) {
		this.execState = execState;
	}
	public void setErrMsg(String errMsg) {
		this.errMsg = errMsg;
	}
}
