package cn.opencodes.framework.core.vo;

import java.io.Serializable;
import java.util.Date;
/**
 * 恶意请求日志
 * @author HJ
 */
public class MaliciousLog implements Serializable {
	private static final long serialVersionUID = 6298844244832631147L;
	//编号
	private Long id;
	//用户名
	private String userName;
	//请求起始结束时间
	private String title;
	//请求方法
	private String method;
	//请求URL
	private String requestUrl;
	//客户端IP
	private String clientHost;
	//客户端浏览器
	private String userAgent;
	//请求参数
	private String parameters;
	//创建时间
	private Date ctime;

	
	/**
	 * 设置：用户名
	 * @param username 用户名
	 */
	public void setUserName(String username) {
		this.userName = username;
	}

	/**
	 * 获取：用户名
	 * @return String
	 */
	public String getUserName() {
		return userName;
	}

	public String getMethod() {
		return method;
	}

	public String getRequestUrl() {
		if (requestUrl != null) {
			requestUrl = (requestUrl.length()>255 ? requestUrl.substring(0,255) : requestUrl);
		}
		return requestUrl;
	}

	public String getClientHost() {
		return clientHost;
	}

	public String getUserAgent() {
		return userAgent;
	}

	public String getParameters() {
		if (parameters != null) {
			parameters = (parameters.length()>255 ? parameters.substring(0,255) : parameters);
		}
		return parameters;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl;
	}

	public void setClientHost(String clientHost) {
		this.clientHost = clientHost;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	public void setParameters(String parameters) {
		this.parameters = parameters;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Date getCtime() {
		return ctime;
	}

	public void setCtime(Date ctime) {
		this.ctime = ctime;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
}
