package cn.opencodes.framework.core.vo;

import java.io.Serializable;
import java.util.Date;
/**
 * 访问日志
 * @author HJ
 */
public class AccessLog implements Serializable{
	private static final long serialVersionUID = -1091444188354648816L;
	
	//编号
	private Long id;
	//用户名称
	private String userName;
	//客户端IP
	private String clientHost;
	//创建时间
	private Date ctime;
	//请求起始结束时间
	private String title;
	//请求URL
	private String requestUrl;
	//请求参数
	private String parameters;
	//请求方法
	private String method;
	//客户端浏览器
	private String userAgent;
	//响应状态
	private Integer status;
	//消耗时间
	private Long consumeTime;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getClientHost() {
		return clientHost;
	}

	public void setClientHost(String clientHost) {
		this.clientHost = clientHost;
	}

	public Date getCtime() {
		return ctime;
	}

	public void setCtime(Date ctime) {
		this.ctime = ctime;
	}
	
	public Long getConsumeTime() {
		return consumeTime;
	}

	public void setConsumeTime(Long consumeTime) {
		this.consumeTime = consumeTime;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title == null ? null : title.trim();
	}

	public String getRequestUrl() {
		if (requestUrl != null) {
			requestUrl = (requestUrl.length()>255 ? requestUrl.substring(0,255) : requestUrl);
		}
		return requestUrl;
	}

	public void setRequestUrl(String requestUrl) {
		this.requestUrl = requestUrl == null ? null : requestUrl.trim();
	}

	public String getParameters() {
		if (parameters != null) {
			parameters = (parameters.length()>255 ? parameters.substring(0,255) : parameters);
		}
		return parameters;
	}
	public void setParameters(String parameters) {
		this.parameters = parameters == null ? null : parameters ;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method == null ? null : method.trim();
	}
	
	public String getUserAgent() {
		return userAgent;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent == null ? null : userAgent.trim();
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

}
