package cn.opencodes.framework.core.utils;

import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.crypto.hash.SimpleHash;

import cn.opencodes.framework.tools.utils.AESUtils;
/**
 * 加密、解密辅助类
 * @author hj
 */
public class SecurityUtils{
	private static final String DEFALUT_SALT = "@[www.hejun.vip]#";
    
	public static String getMD5Hash(String plain) {
		return new Md5Hash(plain, DEFALUT_SALT).toString();
	}
	
	/**
	 * md5加密
	 * @param plain
	 * @param salt
	 */
	public static String getMD5Hash(String plain, String salt) {
		return new Md5Hash(plain, salt).toString();
	}
	
	/**
	 * sha256加密
	 * @param key
	 * @param salt
	 * @param hashIterations 加密次數
	 */
	public static String getSHA256(String key, String salt, int hashIterations) {
		return new SimpleHash("SHA-256", key, salt, 2).toString();
	}
    
    
	/**
     * 加密 AES-256
     * @param content 待加密内容
     * @param password 密钥
     */
	public static String encryptByAES(String content, String password){
		String encContent = null;
		try {
            encContent = AESUtils.encryptByAES(encContent, password);
        } catch (Exception e) {  
            e.printStackTrace();  
        }  
        return encContent;  
	}
	
	
    /**
     * 解密 AES-256
     * @param decryptCode 待解密内容
     * @param password 密钥
     */
    public static String decryptByAES(String decryptCode, String password) {
    	String deccContent = null;
    	try {
    		deccContent = AESUtils.decryptByAES(decryptCode, password);
        } catch (Exception e) {  
            e.printStackTrace();  
        }  
        return deccContent;  
    }
	
}