package cn.opencodes.framework.core.service;

import java.util.Set;

import cn.opencodes.framework.core.vo.UserRoot;
/**
 * 核心框架基础服务
 * @author HJ
 */
public interface AlphaService {
	/**
	 * 获取流水号
	 * @param buscode 业务代码
	 */
	String getSerialNo(String buscode);
	/**
	 * 清空流水号配置缓存
	 * @param buscode 业务代码
	 */
	void clearSerialNoCache(String buscode);
	/**
	 * 获取用户权限集合
	 * @param userId 用户ID
	 */
	Set<String> getUserPermissions(Long userId);
	/**
	 * 清空用户权限缓存
	 * @param userId 用户ID
	 */
	void clearUserPermissionsCache(long userId);
	/**
	 * 获取用户信息
	 * @param userId 用户ID
	 */
	UserRoot getUserRootInfo(long userId);
	/**
	 * 清空用户信息缓存
	 * @param userId 用户ID
	 */
	void clearUserRootInfoCache(long userId);
	/**
	 * 校验客户端公钥、秘钥
	 * @param clientAppKey 		公钥
	 * @param clientAppSecret 	秘钥
	 */
	boolean checkAppKeyAndSecret(String clientAppKey, String clientAppSecret);
	/**
	 * 清空秘钥缓存
	 * @param clientAppKey 公钥
	 */
	void clearAppDeveloperSaltCache(String clientAppKey);
	/**
	 * 收集日志
	 * @param log 日志对象
	 * @param requiredType 日志类型
	 */
	<T> void collect(T log, Class<T> requiredType);
	/**
	 * 关闭日志
     * 等待任务处理完毕 然后关闭线程池
     */
    void closeLog();
}
