package cn.opencodes.framework.core.redis;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
 * 分布式锁
 * @author hj
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface RedisLock {
    /**
     * Redis - key
     */
    String value();
    /**
     * 持锁时间,单位毫秒(默认一分钟)
     */
    long keepMills() default 60000;
    /**
     * 获取锁最多失败次数(默认3次)
     */
    int lockFailMax() default 3;
    /**
     * 失败间隔时间,单位毫秒(默认一秒)
     */
    long sleepMillis() default 1000;
}