package cn.opencodes.framework.core.base;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import cn.opencodes.framework.tools.vo.PageBean;
import cn.opencodes.framework.tools.vo.Query;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
/**
 * 公共基础服务(实现增删改查)
 * @author HJ
 */
public class BaseServiceImpl<T> implements BaseService<T>{
	@Autowired
	private BaseDao<T> baseDao;

	@Override
	@Transactional
	public int save(T t) {
		return baseDao.save(t);
	}

	@Override
	@Transactional
	public int saveBatch(List<T> list) {
		return  baseDao.saveBatch(list);
	}

	@Override
	@Transactional
	public int update(T t) {
		return baseDao.update(t);
	}
	
	@Override
	@Transactional
	public int updateBatch(List<T> list) {
		return baseDao.updateBatch(list);
	}

	@Override
	@Transactional
	public int delete(Long id) {
		return baseDao.delete(id);
	}

	@Override
	@Transactional
	public int deleteBatch(Long[] ids) {
		return baseDao.deleteBatch(ids);
	}

	@Override
	public T query(Long id) {
		return baseDao.query(id);
	}

	@Override
	public PageBean<T> queryByPage(Query query) {
		//设置分页信息，分别是当前页数和每页显示的总记录数【记住：必须在mapper接口中的方法执行之前设置该分页信息】
		Page<Object> pp = 
				PageHelper.startPage(query.getCurrPage(), query.getPageSize(), query.getOrderBy());
		List<T> list = baseDao.queryList(query);
		PageBean<T> p = new PageBean<T>(list, pp.getTotal(), query.getCurrPage(), query.getPageSize());
		return p;
	}

	@Override
	public List<T> queryList(Query query) {
		return baseDao.queryList(query);
	}

}
