package cn.opencodes.framework.core.base;

import java.util.List;

import cn.opencodes.framework.tools.vo.PageBean;
import cn.opencodes.framework.tools.vo.Query;
/**
 * 公共基础服务(增删改查)
 * @author hj
 */
public interface BaseService<T> {
	int save(T t);
	
	int saveBatch(List<T> list);
	
	int update(T t);
	
	int updateBatch(List<T> list);
	
	int delete(Long id);
	
	int deleteBatch(Long[] id);

	T query(Long id);
	
	List<T> queryList(Query query);
	
	PageBean<T> queryByPage(Query query);
	
}
