package cn.opencodes.framework.core.base;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

/**
 * 基础Dao(还需在XML文件里，有对应的SQL语句)
 * @author HJ
 */
public interface BaseDao<T> {
	int save(T t);
	
	int saveBatch(@Param("list")List<T> list);
	
	int update(T t);
	
	int updateBatch(List<T> list);
	
	int delete(Long id);
	
	int deleteBatch(Long[] ids);

	T query(Long id);
	
	List<T> queryList(Map<String, Object> param);

}
