package cn.opencodes.framework.core.base;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.BeanUtils;
import cn.opencodes.framework.tools.vo.CoreConst;
import cn.opencodes.framework.tools.vo.PageBean;
import cn.opencodes.framework.tools.vo.Query;

/**
 * Controller公共组件
 * @author HJ
 */
public abstract class BaseController {
	
	public Query query(Object ...objs){
		Query query = new Query(objs);
		return query;
	}
	
	public Query query(HttpServletRequest req){
		Map<String, Object> params = WebUtils.extractToMap(req);
		Query query = new Query(params);
		if( !isSuperAdmin() ){
			query.put("_curruserId", getUserId());
		}
		return query;
	}
	
	public Query query(Map<String, Object> params){
		Query query = new Query(params);
		if( !isSuperAdmin() ){
			query.put("_curruserId", getUserId());
		}
		return query;
	}
	
	public UserRoot getUserRoot(){
		return WebUtils.getUser();
	}
	
	public String getUserName(){
		return getUserRoot().getUsername();
	}
	
	public long getUserId(){
		return getUserRoot().getId();
	}
	
	public boolean isSuperAdmin(){
		return getUserRoot().getSuperAdmin() == CoreConst.SUPER_ADMIN ;
	}
	
	public <T>PageBean<T> copyPageBean(PageBean<?> page, Class<T> clasz){
		List<T> dataList = new LinkedList<>();
		List<?> list = page.getList();
		for (Object obj : list) {
			try {
				T t = clasz.newInstance();
				BeanUtils.copyBean2Bean(t, obj);
				dataList.add(t);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return new PageBean<T>(dataList, page.getTotal(), page.getCurrPage(), page.getPageSize());
	}
	
	public <T>List<T> copyList(List<?> list, Class<T> clasz){
		List<T> dataList = new LinkedList<>();
		for (Object obj : list) {
			try {
				T t = clasz.newInstance();
				BeanUtils.copyBean2Bean(t, obj);
				dataList.add(t);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return dataList;
	}
	
	public <T>T copyBean(Object obj, Class<T> clasz){
		T t = null;
		try {
			t = clasz.newInstance();
			BeanUtils.copyBean2Bean(t, obj);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return t;
	}
	
}
