package cn.opencodes.framework.autoconfigure.properties;

import java.util.HashMap;
import java.util.Map;

import org.springframework.boot.context.properties.ConfigurationProperties;
/**
 * 配置
 * @author hj
 */
@ConfigurationProperties(prefix = "swagger")
public class SwaggerProperties {
	private String groupName="default";
	private String basePackage;
	private String title;
	private String description;
	private String serviceUrl;
	private String author;
	private String email;
	private String websit;
	private String version="1.0.0-SNAPSHOT";
	private Map<Integer, String> messages = initMessages();

	public String getGroupName() {
		return groupName;
	}

	public String getBasePackage() {
		return basePackage;
	}

	public String getTitle() {
		return title;
	}

	public String getServiceUrl() {
		return serviceUrl;
	}

	public String getVersion() {
		return version;
	}

	public Map<Integer, String> getMessages() {
		return messages;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public void setBasePackage(String basePackage) {
		this.basePackage = basePackage;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setServiceUrl(String serviceUrl) {
		this.serviceUrl = serviceUrl;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public void setMessages(Map<Integer, String> messages) {
		this.messages = messages;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getAuthor() {
		return author;
	}

	public String getEmail() {
		return email;
	}

	public String getWebsit() {
		return websit;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setWebsit(String websit) {
		this.websit = websit;
	}

	
	private Map<Integer, String> initMessages(){
		Map<Integer, String> map = new HashMap<>();
		map.put(500, "请求服务异常");
		map.put(404, "找不到资源");
		map.put(403, "权限不足");
		map.put(401, "授权认证失败");
		map.put(400, "参数错误");
		map.put(200, "请求服务成功");
		map.put(0, "请求服务失败");
		map.put(-1, "传参为空或不合理");
		return map;
	}
}