package cn.opencodes.framework.autoconfigure.properties;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
/**
 * 系统配置
 * @author hj
 */
@ConfigurationProperties(prefix = "al")
public class AlphaProperties {
	@Value("${spring.profiles.active}")
	private String active;
	//模块名称
	private String module;
	//登录地址
	private String loginUrl="/login";
	//调试用户
	private long debug=0;
	//是否开启appToken拦截验证
	private boolean openToken=true;
	//是否开启appSecret拦截验证
	private boolean openSecret=false;
	//分页是否自动识别数据库类型
	private boolean autoDialect=false;
	//token有效时长，7天，单位秒
	private long expire=604800;
	//限制用户每秒允许访问相同资源次数
	private int ratemax=5;
	//秘钥
	private String secret="[www.opencodes.cn]";
	//shiro-url权限拦截
    private List<String> filters;
    //静态资源
    private List<String> resources;
    //拦截器
    private Map<String, String> interceptors;


	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public List<String> getFilters() {
		return filters;
	}

	public void setFilters(List<String> filters) {
		this.filters = filters;
	}

	public Map<String, String> getInterceptors() {
		return interceptors;
	}

	public void setInterceptors(Map<String, String> interceptors) {
		this.interceptors = interceptors;
	}


	public String getActive() {
		return active;
	}

	public void setActive(String active) {
		this.active = active;
	}

	public List<String> getResources() {
		return resources;
	}

	public void setResources(List<String> resources) {
		this.resources = resources;
	}

	public boolean isOpenToken() {
		openToken = true;
		return openToken;
	}

	public void setOpenToken(boolean openToken) {
		this.openToken = openToken;
	}

	public boolean isOpenSecret() {
		return openSecret;
	}

	public void setOpenSecret(boolean openSecret) {
		this.openSecret = openSecret;
	}

	public boolean isAutoDialect() {
		return autoDialect;
	}

	public void setAutoDialect(boolean autoDialect) {
		this.autoDialect = autoDialect;
	}

	public long getExpire() {
		return expire;
	}

	public void setExpire(long expire) {
		this.expire = expire;
	}

	public String getSecret() {
		return secret;
	}

	public void setSecret(String secret) {
		this.secret = secret;
	}

	public int getRatemax() {
		return ratemax;
	}

	public void setRatemax(int ratemax) {
		this.ratemax = ratemax;
	}

	public String getLoginUrl() {
		return loginUrl;
	}

	public void setLoginUrl(String loginUrl) {
		this.loginUrl = loginUrl;
	}

	public long getDebug() {
		return debug;
	}

	public void setDebug(long debug) {
		this.debug = debug;
	}

}