package cn.opencodes.framework.autoconfigure;

import java.util.Properties;

import javax.sql.DataSource;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;

import com.github.pagehelper.PageHelper;

import cn.opencodes.framework.autoconfigure.properties.AlphaProperties;
/**
 * 分页插件配置
 * @author HJ
 */
@ConditionalOnBean(DataSource.class)
public class PageHelperConfiguration {
	//配置mybatis的分页插件pageHelper
    @Bean
    public PageHelper pageHelper(AlphaProperties props){
        PageHelper pageHelper = new PageHelper();
        Properties properties = new Properties();
        //数据库标识
        properties.setProperty("dialect","mysql");
        if (props.isAutoDialect()) {
        	//运行时自动获取dialect
        	properties.setProperty("autoRuntimeDialect","true");
		}
        //设置为true时，会将startPage第一个参数offset当成pageNum页码使用 
        properties.setProperty("offsetAsPageNum","true");
        //当supportMethodsArguments参数设置为true时，rowBoundsWithCount参数有效
        //设置为true时使用RowBounds分页会进行count查询
        properties.setProperty("rowBoundsWithCount","true");
        //分页参数合理化，默认false禁用,如果pageNum<1会查询第一页，如果pageNum>pages会查询最后一页
        properties.setProperty("reasonable","true");
        //多数据源时，获取jdbcurl后是否关闭数据源
        //properties.setProperty("closeConn","true");
        pageHelper.setProperties(properties);
        return pageHelper;
    }
}
