/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.poi;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.view.PoiBaseView;
import cn.opencodes.utils.collections.CollectionUtils;
import cn.opencodes.utils.parse.BeanUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EasypoiUtils {
    public static ExportModel exporter(HttpServletRequest request, HttpServletResponse response) {
        return new ExportModel(request, response);
    }

    public static class ExportModel
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = 1L;
        private HttpServletRequest req;
        private HttpServletResponse res;
        private ExportParams params = new ExportParams(null, null, ExcelType.XSSF);

        public ExportModel(HttpServletRequest request, HttpServletResponse response) {
            this.req = request;
            this.res = response;
            this.put("params", this.params);
        }

        public ExportModel addFileName(String fileName) {
            this.put("fileName", fileName);
            return this;
        }

        public ExportModel addDataList(List<?> dataList) {
            if (CollectionUtils.isNotEmpty(dataList)) {
                this.put("data", dataList);
                this.put("entity", dataList.get(0).getClass());
            }
            return this;
        }

        public ExportModel addDataList(List<?> dataList, Class<?> classz) {
            List<?> copyList = this.copyList(dataList, classz);
            return this.addDataList(copyList);
        }

        public ExportModel addExportParams(ExportParams ep) {
            this.put("params", ep);
            return this;
        }

        public ExportModel addSheetName(String sheetName) {
            this.params.setSheetName(sheetName);
            return this;
        }

        public void renderTo(String view) {
            PoiBaseView.render((Map)this, (HttpServletRequest)this.req, (HttpServletResponse)this.res, (String)view);
        }

        private <T> List<T> copyList(List<?> list, Class<T> classz) {
            LinkedList<T> dataList = new LinkedList<T>();
            for (Object obj : list) {
                try {
                    T t = classz.newInstance();
                    BeanUtils.copyBean2Bean(t, obj);
                    dataList.add(t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return dataList;
        }
    }
}

