/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.parse;

import cn.opencodes.utils.exception.RException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class BeanUtils
extends PropertyUtilsBean {
    public static void copyBean2Bean(Object dest, Object orig) {
        try {
            BeanUtils.convert(dest, orig);
        }
        catch (Exception e) {
            throw new RException(e.toString(), -1);
        }
    }

    private static void convert(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value2 = ((DynaBean)orig).get(name);
                try {
                    BeanUtils.getInstance().setSimpleProperty(dest, name, value2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value = ((Map)orig).get(name);
                try {
                    BeanUtils.getInstance().setSimpleProperty(dest, name, value);
                }
                catch (Exception value2) {}
            }
        } else {
            PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                try {
                    Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                    BeanUtils.getInstance().setSimpleProperty(dest, name, value);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void copyBeanNotNull2Bean(Object databean, Object tobean) {
        try {
            BeanUtils.copyBeanNotNull2Bean1(databean, tobean);
        }
        catch (Exception e) {
            throw new RException(e.toString(), -1);
        }
    }

    private static void copyBeanNotNull2Bean1(Object databean, Object tobean) throws Exception {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)databean);
        for (int i = 0; i < origDescriptors.length; ++i) {
            String name = origDescriptors[i].getName();
            if ("class".equals(name) || !PropertyUtils.isReadable((Object)databean, (String)name) || !PropertyUtils.isWriteable((Object)tobean, (String)name)) continue;
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)databean, (String)name);
                if (value == null) continue;
                BeanUtils.getInstance().setSimpleProperty(tobean, name, value);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copyBean2Map(Map map, Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            String propname = pd.getName();
            try {
                Object propvalue = PropertyUtils.getSimpleProperty((Object)bean, (String)propname);
                map.put(propname, propvalue);
                continue;
            }
            catch (Exception e) {
                throw new RException(e.toString(), -1);
            }
        }
    }

    public static void copyMap2Bean(Object bean, Map map) {
        try {
            BeanUtils.copyMap2Bean1(bean, map);
        }
        catch (Exception e) {
            throw new RException(e.toString(), -1);
        }
    }

    private static void copyMap2Bean1(Object bean, Map map) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || map == null) {
            return;
        }
        for (String name : map.keySet()) {
            if (name == null) continue;
            Object value = map.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                BeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2Bean_Nobig(Object bean, Map map) {
        try {
            BeanUtils.copyMap2Bean_Nobig1(bean, map);
        }
        catch (Exception e) {
            throw new RException(e.toString(), -1);
        }
    }

    private static void copyMap2Bean_Nobig1(Object bean, Map map) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || map == null) {
            return;
        }
        for (String name : map.keySet()) {
            if (name == null) continue;
            Object value = map.get(name);
            try {
                Class clazz;
                if (value == null || null == (clazz = PropertyUtils.getPropertyType((Object)bean, (String)name))) continue;
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.util.Date")) {
                    value = new Date(((Timestamp)value).getTime());
                }
                BeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2Bean(Object bean, Map map, String defaultValue) {
        try {
            BeanUtils.copyMap2Bean1(bean, map, defaultValue);
        }
        catch (Exception e) {
            throw new RException(e.toString(), -1);
        }
    }

    private static void copyMap2Bean1(Object bean, Map map, String defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || map == null) {
            return;
        }
        for (String name : map.keySet()) {
            if (name == null) continue;
            Object value = map.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                if (className.equalsIgnoreCase("java.lang.String") && value == null) {
                    value = defaultValue;
                }
                BeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static <T> List<T> copyList(List<?> list, Class<T> clasz) {
        LinkedList<T> dataList = new LinkedList<T>();
        for (Object obj : list) {
            try {
                T t = clasz.newInstance();
                BeanUtils.copyBean2Bean(t, obj);
                dataList.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataList;
    }

    public static <T> T copyBean(Object obj, Class<T> clasz) {
        T t = null;
        try {
            t = clasz.newInstance();
            BeanUtils.copyBean2Bean(t, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }
}

