/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.monitor;

import cn.opencodes.utils.monitor.MonitorInfo;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MonitorUtils {
    public static MonitorInfo getMonitorInfo() {
        OperatingSystemMXBean osmx = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        MonitorInfo sm = new MonitorInfo();
        sm.setSysTime(System.currentTimeMillis());
        sm.setOsName(System.getProperty("os.name"));
        sm.setOsArch(System.getProperty("os.arch"));
        sm.setOsVersion(System.getProperty("os.version"));
        sm.setUserLanguage(System.getProperty("user.language"));
        sm.setUserDir(System.getProperty("user.dir"));
        sm.setTotalPhysical(osmx.getTotalPhysicalMemorySize() / 1024L / 1024L);
        sm.setFreePhysical(osmx.getFreePhysicalMemorySize() / 1024L / 1024L);
        sm.setMemoryRate(BigDecimal.valueOf((1.0 - (double)osmx.getFreePhysicalMemorySize() * 1.0 / (double)osmx.getTotalPhysicalMemorySize()) * 100.0).setScale(2, RoundingMode.HALF_UP));
        sm.setProcessors(osmx.getAvailableProcessors());
        sm.setJvmName(System.getProperty("java.vm.name"));
        sm.setJavaVersion(System.getProperty("java.version"));
        sm.setJavaHome(System.getProperty("java.home"));
        sm.setJavaTotalMemory(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        sm.setJavaFreeMemory(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        sm.setJavaMaxMemory(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        sm.setUserName(System.getProperty("user.name"));
        sm.setSystemCpuLoad(BigDecimal.valueOf(osmx.getSystemCpuLoad() * 100.0).setScale(2, RoundingMode.HALF_UP));
        sm.setUserTimezone(System.getProperty("user.timezone"));
        return sm;
    }
}

