/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.mail;

import cn.opencodes.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSenderUtils {
    public static void send(String toMail, String csMail, String subject, String message, String username, String password, String host, int smtpPort, String from, String charSet) throws AddressException, MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        Session session = Session.getInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(toMail));
        if (StringUtils.isNotEmpty((String)csMail)) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)csMail));
        }
        msg.setSubject(subject, charSet);
        msg.setContent((Object)message, "text/html;charset=UTF-8");
        msg.setSentDate(new Date());
        Transport transport = session.getTransport();
        transport.connect(host, smtpPort, username, password);
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    public static void sendForFile(String toMail, String csMail, String subject, String message, String[] files, String username, String password, String host, int smtpPort, String from, String charSet) throws AddressException, MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        Session session = Session.getInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(toMail));
        if (StringUtils.isNotEmpty((String)csMail)) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)csMail));
        }
        msg.setSubject(subject, charSet);
        MimeMultipart mul = new MimeMultipart();
        MimeBodyPart mdp = new MimeBodyPart();
        mdp.setContent((Object)message, "text/html;charset=UTF-8");
        mul.addBodyPart((BodyPart)mdp);
        for (String path : files) {
            mdp = new MimeBodyPart();
            DataHandler dh = new DataHandler((DataSource)new FileDataSource(path));
            mdp.setDataHandler(dh);
            mdp.setFileName(MimeUtility.encodeText((String)dh.getName()));
            mul.addBodyPart((BodyPart)mdp);
        }
        msg.setContent((Multipart)mul);
        msg.setSentDate(new Date());
        Transport transport = session.getTransport();
        transport.connect(host, smtpPort, username, password);
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }
}

