/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.mail;

import cn.opencodes.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;

public class EmailSenderConfig {
    private String from;
    private String fromNick;
    private String charSet;
    private String username;
    private String password;
    private String host;
    private String smtpPort;
    private Map<String, String> hostMap = new HashMap<String, String>();

    public EmailSenderConfig(String from, String fromNick, String userName, String password, String charSet, String host, String smtpPort) {
        this.from = from;
        this.fromNick = fromNick;
        this.charSet = charSet;
        this.username = userName;
        this.password = password;
        this.host = host;
        this.smtpPort = smtpPort;
        this.initHost();
    }

    private void initHost() {
        this.hostMap.put("smtp.126", "smtp.126.com");
        this.hostMap.put("smtp.qq", "smtp.qq.com");
        this.hostMap.put("smtp.163", "smtp.163.com");
        this.hostMap.put("smtp.sina", "smtp.sina.com.cn");
        this.hostMap.put("smtp.tom", "smtp.tom.com");
        this.hostMap.put("smtp.263", "smtp.263.net");
        this.hostMap.put("smtp.yahoo", "smtp.mail.yahoo.com");
        this.hostMap.put("smtp.hotmail", "smtp.live.com");
        this.hostMap.put("smtp.gmail", "smtp.gmail.com");
        this.hostMap.put("smtp.port.gmail", "465");
    }

    public String getFrom() {
        if (StringUtils.isBlank((String)this.from)) {
            this.from = this.username;
        }
        return this.from;
    }

    public String getFromNick() {
        if (StringUtils.isBlank((String)this.fromNick)) {
            this.fromNick = this.getFrom();
        } else {
            try {
                this.fromNick = MimeUtility.encodeText((String)this.fromNick) + "<" + this.getFrom() + ">";
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                this.fromNick = this.from;
            }
        }
        return this.fromNick;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setFromNick(String fromNick) {
        this.fromNick = fromNick;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        if (StringUtils.isNotBlank((String)this.host)) {
            return this.host.replace("pop3", "smtp");
        }
        Pattern pattern = Pattern.compile("\\w+@(\\w+)(\\.\\w+){1,2}");
        Matcher matcher = pattern.matcher(this.getFrom());
        String key = "unSupportEmail";
        if (matcher.find()) {
            key = "smtp." + matcher.group(1);
        }
        if (this.hostMap.containsKey(key)) {
            return this.hostMap.get(key);
        }
        throw new RuntimeException("unSupportEmail");
    }

    public int getSmtpPort() {
        if (StringUtils.isBlank((String)this.smtpPort)) {
            Pattern pattern = Pattern.compile("\\w+@(\\w+)(\\.\\w+){1,2}");
            Matcher matcher = pattern.matcher(this.getFrom());
            String key = "unSupportEmail";
            if (matcher.find()) {
                key = "smtp.port." + matcher.group(1);
            }
            if (this.hostMap.containsKey(key)) {
                return Integer.parseInt(this.hostMap.get(key));
            }
        }
        return 25;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }
}

