/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.http;

import cn.opencodes.utils.StringUtils;
import cn.opencodes.utils.http.UserAgent;
import cz.mallat.uasparser.OnlineUpdater;
import cz.mallat.uasparser.UASparser;
import cz.mallat.uasparser.UserAgentInfo;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserUtil.class);
    private static UASparser uasParser = null;
    private static String android = "Android";
    private static String iphone = "iPhone";
    private static String ipad = "iPad";
    private static String phoneReg = "\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static String tableReg = "\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static Pattern phonePat = Pattern.compile(phoneReg, 2);
    private static Pattern tablePat = Pattern.compile(tableReg, 2);

    public static boolean checkMobileOrPC(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        System.out.println("==========================\u7ec8\u7aef\u5224\u65ad\u5f00\u59cb========================================");
        System.out.println("\u8bbe\u5907\u68c0\u6d4b\uff1a" + userAgent);
        Matcher matcherPhone = phonePat.matcher(userAgent);
        Matcher matcherTable = tablePat.matcher(userAgent);
        boolean result = false;
        if (matcherPhone.find() || matcherTable.find()) {
            result = true;
        }
        System.out.println("===========================\u7ec8\u7aef\u5224\u65ad\u7ed3\u675f=======================================");
        return result;
    }

    public static boolean checkMobileOrPC(String userAgent) {
        System.out.println("\u8bbe\u5907\u68c0\u6d4b\uff1a" + userAgent);
        Matcher matcherPhone = phonePat.matcher(userAgent);
        Matcher matcherTable = tablePat.matcher(userAgent);
        return matcherPhone.find() || matcherTable.find();
    }

    public static String getDeviceType(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u8bbe\u5907\u7c7b\u578b\uff1a" + userAgentInfo.getDeviceType());
        return userAgentInfo.getDeviceType();
    }

    public static String getOsName(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u64cd\u4f5c\u7cfb\u7edf\u8be6\u7ec6\u540d\u79f0\uff1a" + userAgentInfo.getOsName());
        return userAgentInfo.getOsName();
    }

    public static String getUaName(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u6d4f\u89c8\u5668\u540d\u79f0\u548c\u7248\u672c\uff1a" + userAgentInfo.getUaName());
        return userAgentInfo.getUaName();
    }

    public static boolean isWeChatBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        return userAgent.toLowerCase().indexOf("micromessenger") > -1;
    }

    public static String getMobileModel(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        Pattern pattern = Pattern.compile(";\\s?(\\S*?\\s?\\S*?)\\s?(Build)?/");
        Matcher matcher = pattern.matcher(userAgent);
        String mobileModel = null;
        if (matcher.find()) {
            mobileModel = matcher.group(1).trim();
        }
        if (userAgent.indexOf("iphone") > 0) {
            mobileModel = "iphone";
        }
        if (userAgent.indexOf("ipad") > 0) {
            mobileModel = "ipad";
        }
        return mobileModel;
    }

    public static String getBrowerType(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u7c7b\u578b\uff1a" + userAgentInfo.getType());
        return userAgentInfo.getType();
    }

    public static String getBrowserVersionInfo(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u6d4f\u89c8\u5668\u7248\u672c\uff1a" + userAgentInfo.getBrowserVersionInfo());
        return userAgentInfo.getBrowserVersionInfo();
    }

    public static String getMobileOS(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        if (userAgent.contains(android)) {
            return android;
        }
        if (userAgent.contains(iphone)) {
            return iphone;
        }
        if (userAgent.contains(ipad)) {
            return ipad;
        }
        return "others";
    }

    public static String getOsFamily(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u64cd\u4f5c\u7cfb\u7edf\u5bb6\u65cf\uff1a" + userAgentInfo.getOsFamily());
        return userAgentInfo.getOsFamily();
    }

    public static String getUaFamily(HttpServletRequest request) throws IOException {
        String userAgent = request.getHeader("user-agent").toLowerCase();
        UserAgentInfo userAgentInfo = uasParser.parse(userAgent);
        LOG.debug("\u6d4f\u89c8\u5668\u540d\u79f0\uff1a" + userAgentInfo.getUaFamily());
        return userAgentInfo.getUaFamily();
    }

    public static UserAgent analyticUserAgent(String userAgent) {
        UserAgent ua = null;
        if (StringUtils.isNotBlank((String)userAgent)) {
            try {
                UserAgentInfo info = uasParser.parse(userAgent);
                ua = new UserAgent();
                ua.setBrowserName(info.getUaFamily());
                ua.setBrowserVersion(info.getBrowserVersionInfo());
                ua.setBrowserType(info.getType());
                ua.setOsName(info.getOsFamily());
            }
            catch (IOException e) {
                e.printStackTrace();
                ua = null;
            }
        }
        return ua;
    }

    static {
        try {
            uasParser = new UASparser(OnlineUpdater.getVendoredInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

