/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.file;

import cn.opencodes.utils.DateUtils;
import cn.opencodes.utils.IDUtils;
import cn.opencodes.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String getPath(String path) {
        if (path.contains(":")) {
            return path.replace("\\\\", "\\");
        }
        path = path.replace("\\", "/").trim();
        path = path.replace("//", "/");
        return path;
    }

    public static boolean appendTextInNewLine(String path, String text) {
        return FileUtils.appendText(path, text + System.getProperty("line.separator"));
    }

    public static boolean appendText(String path, String text) {
        try {
            File file = new File(path);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "utf-8"));){
                writer.write(text);
                writer.close();
            }
            return true;
        }
        catch (IOException e) {
            LOG.error("\u5199\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    public static void copyFile(File inFile, File outFile) {
        try {
            FileUtils.copyFile(new FileInputStream(inFile), outFile);
        }
        catch (FileNotFoundException ex) {
            LOG.error("\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, File outFile) {
        FileOutputStream out = null;
        try {
            byte[] data = FileUtils.readAll(in);
            out = new FileOutputStream(outFile);
            ((OutputStream)out).write(data, 0, data.length);
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {
                LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
            }
        }
    }

    public static byte[] readAll(File file) {
        try {
            return FileUtils.readAll(new FileInputStream(file));
        }
        catch (Exception ex) {
            LOG.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public static byte[] readAll(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException ex) {
            LOG.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)ex);
        }
        return out.toByteArray();
    }

    public static FileInputStream getInputStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException ex) {
            LOG.error("\u6587\u4ef6\u6ca1\u6709\u627e\u5230", (Throwable)ex);
            return null;
        }
    }

    public static InputStream getInputStreamByClass(String path) {
        return FileUtils.class.getResourceAsStream(path);
    }

    public static boolean existsFile(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception ex) {
            LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
        }
        return false;
    }

    public static File createAndWriteFile(String path, byte[] data) {
        try {
            File file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            try (FileOutputStream out = new FileOutputStream(file);){
                ((OutputStream)out).write(data, 0, data.length);
            }
            return file;
        }
        catch (Exception ex) {
            LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public static File createAndWriteFile(String path, String text) {
        try {
            File file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));){
                writer.write(text);
            }
            return file;
        }
        catch (Exception ex) {
            LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public static boolean removeFile(String path) {
        try {
            File file = new File(path);
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
            return true;
        }
        catch (Exception ex) {
            LOG.error("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25", (Throwable)ex);
            return false;
        }
    }

    public static void deleteFiles(String workspaceRootPath) {
        File file = new File(workspaceRootPath);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    public static List<String> getTextFileContent(String path) {
        try {
            return FileUtils.getTextFileContent(new FileInputStream(path));
        }
        catch (FileNotFoundException ex) {
            if (!path.contains("apdplat.licence")) {
                LOG.error("\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)ex);
            }
            return Collections.emptyList();
        }
    }

    public static List<String> getTextFileContent(InputStream in) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Exception e) {
            LOG.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public static long getFileSize(File file) {
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        return 0L;
    }

    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public static boolean isWindowsOS() {
        String os = System.getProperty("os.name");
        return StringUtils.isNotBlank((String)os) && os.startsWith("Windows");
    }

    public static String buildPath(String prefix, String suffix) {
        String path = DateUtils.formatNowDay("yyyyMMdd") + "/" + IDUtils.guid();
        if (StringUtils.isNotBlank((String)prefix)) {
            path = prefix + "/" + path;
        }
        return path + "." + suffix;
    }
}

