/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class RException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String msg;
    private int code;

    public RException(String msg) {
        super(msg);
        this.msg = msg;
        this.code = 500;
    }

    public RException(Throwable e) {
        super(e);
        this.msg = RException.getStackTrace(e, 500);
        this.code = 500;
    }

    public RException(String msg, Throwable e) {
        super(msg, e);
        this.msg = msg;
        this.code = 500;
    }

    public RException(String msg, int code) {
        super(msg);
        this.msg = msg;
        this.code = code;
    }

    public RException(String msg, int code, Throwable e) {
        super(msg, e);
        this.msg = msg;
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable ex, int len) {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException iOException) {}
        }
        String msg = sw.toString();
        if (len > 0 && msg.length() > len) {
            return msg.substring(0, len);
        }
        return sw.toString();
    }
}

