/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.collections;

import cn.opencodes.utils.StringUtils;
import cn.opencodes.utils.collections.CollectionUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapUtils
extends org.apache.commons.collections.MapUtils {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = MapUtils.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return MapUtils.zip(StringUtils.split((String)keys, (String)delimiter), StringUtils.split((String)values, (String)delimiter), isOrder);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtils.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isOrder) {
        return MapUtils.newHashMap(16, isOrder);
    }
}

