/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils.collections;

import cn.opencodes.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    public static <T> List<T> asList(String a, String regex) {
        if (StringUtils.isNotBlank((String)a)) {
            String[] arry;
            ArrayList<String> list = new ArrayList<String>();
            for (String s : arry = a.trim().split(regex)) {
                list.add(s);
            }
            return list;
        }
        return null;
    }

    public static <T> List<T> asList(String a) {
        return CollectionUtils.asList(a, ",");
    }

    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return null == set ? Collections.emptySet() : set;
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return null == list ? Collections.emptyList() : list;
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollectionUtils.isNotEmpty(collection) && collection.contains(value);
    }

    public static <T> Map<T, Integer> countElement(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                T t = iter.next();
                Integer count = (Integer)countMap.get(t);
                if (null == count) {
                    countMap.put(t, 1);
                    continue;
                }
                countMap.put(t, count + 1);
            }
        }
        return countMap;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !CollectionUtils.isEmpty(array);
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }
}

