/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {
    public static String[] stringToPinyin(String src) {
        return PinyinUtil.stringToPinyin(src, false, null);
    }

    public static String[] stringToPinyin(String src, String separator) {
        return PinyinUtil.stringToPinyin(src, true, separator);
    }

    public static String[] stringToPinyin(String src, boolean isPolyphone, String separator) {
        if ("".equals(src) || null == src) {
            return null;
        }
        char[] srcChar = src.toCharArray();
        int srcCount = srcChar.length;
        String[] srcStr = new String[srcCount];
        for (int i = 0; i < srcCount; ++i) {
            srcStr[i] = PinyinUtil.charToPinyin(srcChar[i], isPolyphone, separator);
        }
        return srcStr;
    }

    public static String charToPinyin(char src, boolean isPolyphone, String separator) {
        StringBuffer tempPinying;
        block6: {
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            tempPinying = new StringBuffer();
            if (src > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)src, (HanyuPinyinOutputFormat)defaultFormat);
                    if (isPolyphone && null != separator) {
                        for (int i = 0; i < strs.length; ++i) {
                            tempPinying.append(strs[i]);
                            if (strs.length == i + 1) continue;
                            tempPinying.append(separator);
                        }
                        break block6;
                    }
                    tempPinying.append(strs[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                tempPinying.append(src);
            }
        }
        return tempPinying.toString();
    }

    public static String hanziToPinyin(String hanzi) {
        return PinyinUtil.hanziToPinyin(hanzi, " ");
    }

    public static String hanziToPinyin(String hanzi, String separator) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pinyingStr = "";
        try {
            pinyingStr = PinyinHelper.toHanyuPinyinString((String)hanzi, (HanyuPinyinOutputFormat)defaultFormat, (String)separator);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pinyingStr;
    }

    public static char[] getHeadByChar(char src, boolean isCapital) {
        if (src <= '\u0080') {
            return new char[]{src};
        }
        String[] pinyingStr = PinyinHelper.toHanyuPinyinStringArray((char)src);
        int polyphoneSize = pinyingStr.length;
        char[] headChars = new char[polyphoneSize];
        int i = 0;
        for (String s : pinyingStr) {
            char headChar = s.charAt(0);
            headChars[i] = isCapital ? Character.toUpperCase(headChar) : headChar;
            ++i;
        }
        return headChars;
    }

    public static char[] getHeadByChar(char src) {
        return PinyinUtil.getHeadByChar(src, true);
    }

    public static String getPinYin(String src) {
        char[] t1 = null;
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        String t4 = "";
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; ++i) {
                if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray((char)t1[i], (HanyuPinyinOutputFormat)t3);
                    t4 = t4 + t2[0];
                    continue;
                }
                t4 = t4 + Character.toString(t1[i]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return t4;
    }

    public static String getPinYinHeadChar(String str) {
        String convert = "";
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? convert + pinyinArray[0].charAt(0) : convert + word;
        }
        return convert;
    }

    public static String getCnASCII(String cnStr) {
        StringBuffer strBuf = new StringBuffer();
        byte[] bGBK = cnStr.getBytes();
        for (int i = 0; i < bGBK.length; ++i) {
            strBuf.append(Integer.toHexString(bGBK[i] & 0xFF));
        }
        return strBuf.toString();
    }

    public static String converterToFirstSpell(String chines) {
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = pinyinName + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinName = pinyinName + nameChar[i];
        }
        return pinyinName;
    }

    public static String converterToSpell(String chines) {
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = pinyinName + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinName = pinyinName + nameChar[i];
        }
        return pinyinName;
    }
}

