/*
 * Decompiled with CFR 0.152.
 */
package org.hy.xflow.engine.bean;

import java.util.List;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.xflow.engine.bean.ActivityInfo;
import org.hy.xflow.engine.bean.ActivityRoute;
import org.hy.xflow.engine.bean.FlowInfo;
import org.hy.xflow.engine.bean.Participant;
import org.hy.xflow.engine.bean.ProcessParticipant;
import org.hy.xflow.engine.bean.User;
import org.hy.xflow.engine.bean.UserRole;
import org.hy.xflow.engine.common.BaseModel;
import org.hy.xflow.engine.common.IDHelp;
import org.hy.xflow.engine.enums.ParticipantTypeEnum;
import org.hy.xflow.engine.enums.RouteTypeEnum;

public class FlowProcess
extends BaseModel {
    private static final long serialVersionUID = -4724247321457107633L;
    private String templateID;
    private List<ProcessParticipant> participants;
    private List<ProcessParticipant> futureParticipants;
    private String processID;
    private String workID;
    private String serviceDataID;
    private String splitProcessID;
    private Integer processNo;
    private String currentActivityID;
    private String currentActivityCode;
    private String currentActivityName;
    private String previousProcessID;
    private String previousActivityID;
    private String previousActivityCode;
    private String previousActivityName;
    private String previousOperateTypeID;
    private String nextProcessID;
    private String nextActivityID;
    private String nextActivityCode;
    private String nextActivityName;
    private String createrID;
    private String creater;
    private String createOrgID;
    private String createOrg;
    private Date createTime;
    private Double summary;
    private Double summaryPass;
    private Integer counter;
    private Integer counterPass;
    private String passType;
    private Integer isPass;
    private String limitUserID;
    private String limitOrgID;
    private Date limitTime;
    private Date operateTime;
    private Integer operateTimeLen;
    private String operateTypeID;
    private String operateType;
    private String operateUserID;
    private String operateUser;
    private String operateOrgID;
    private String operateOrg;
    private String operateFiles;
    private String operateDatas;
    private String infoComment;

    public FlowProcess init_CreateFlow(User i_User, FlowInfo i_Flow, ActivityInfo i_Activity) {
        this.templateID = i_Flow.getFlowTemplateID();
        this.processID = i_Flow.getLastProcessID();
        this.serviceDataID = i_Flow.getServiceDataID();
        this.workID = i_Flow.getWorkID();
        this.splitProcessID = "";
        this.currentActivityID = i_Activity.getActivityID();
        this.currentActivityCode = i_Activity.getActivityCode();
        this.currentActivityName = i_Activity.getActivityName();
        this.processNo = 1;
        this.previousProcessID = "";
        this.previousActivityID = "";
        this.previousActivityCode = "";
        this.previousActivityName = "";
        this.previousOperateTypeID = "";
        this.nextProcessID = "";
        this.nextActivityID = "";
        this.nextActivityCode = "";
        this.nextActivityName = "";
        this.createrID = i_User.getUserID();
        this.creater = i_User.getUserName();
        this.createOrgID = i_User.getOrgID();
        this.createOrg = i_User.getOrgName();
        this.createTime = new Date();
        this.limitUserID = "";
        this.limitOrgID = "";
        this.limitTime = new Date("2000-01-01 00:00:00");
        this.operateTime = this.createTime;
        this.operateTimeLen = 0;
        this.operateTypeID = "";
        this.operateType = "";
        this.operateUserID = this.createrID;
        this.operateUser = this.creater;
        this.operateOrgID = this.createOrgID;
        this.operateOrg = this.createOrg;
        this.operateFiles = "";
        this.operateDatas = "";
        this.infoComment = "";
        this.summary = 0.0;
        this.summaryPass = 0.0;
        this.counter = 0;
        this.counterPass = 0;
        this.passType = "";
        this.isPass = 0;
        return this;
    }

    public FlowProcess init_ToNext(User i_User, FlowInfo i_Flow, FlowProcess io_Previous, ActivityRoute i_Route) {
        this.templateID = i_Flow.getFlowTemplateID();
        this.processID = IDHelp.makeID();
        this.serviceDataID = i_Flow.getServiceDataID();
        this.workID = i_Flow.getWorkID();
        this.splitProcessID = "";
        this.currentActivityID = i_Route.getNextActivity().getActivityID();
        this.currentActivityCode = i_Route.getNextActivity().getActivityCode();
        this.currentActivityName = i_Route.getNextActivity().getActivityName();
        this.processNo = -1;
        this.previousProcessID = io_Previous.getProcessID();
        this.previousActivityID = io_Previous.getCurrentActivityID();
        this.previousActivityCode = io_Previous.getCurrentActivityCode();
        this.previousActivityName = io_Previous.getCurrentActivityName();
        this.previousOperateTypeID = i_Route.getRouteType().getRouteTypeID().getValue();
        io_Previous.nextProcessID = this.processID;
        io_Previous.nextActivityID = this.currentActivityID;
        io_Previous.nextActivityCode = this.currentActivityCode;
        io_Previous.nextActivityName = this.currentActivityName;
        this.nextProcessID = "";
        this.nextActivityID = "";
        this.nextActivityName = "";
        this.createrID = i_User.getUserID();
        this.creater = i_User.getUserName();
        this.createOrgID = i_User.getOrgID();
        this.createOrg = i_User.getOrgName();
        this.createTime = new Date();
        this.limitUserID = "";
        this.limitOrgID = "";
        this.limitTime = new Date("2000-01-01 00:00:00");
        this.operateTime = this.createTime;
        this.operateTimeLen = 0;
        this.operateTypeID = "";
        this.operateType = "";
        this.operateUserID = this.createrID;
        this.operateUser = this.creater;
        this.operateOrgID = this.createOrgID;
        this.operateOrg = this.createOrg;
        io_Previous.operateTime = this.createTime;
        io_Previous.operateTimeLen = 0;
        io_Previous.operateTypeID = i_Route.getRouteType().getRouteTypeID().getValue();
        io_Previous.operateType = i_Route.getRouteType().getRouteType();
        io_Previous.operateUserID = this.createrID;
        io_Previous.operateUser = this.creater;
        io_Previous.operateOrgID = this.createOrgID;
        io_Previous.operateOrg = this.createOrg;
        this.operateFiles = "";
        this.operateDatas = "";
        this.infoComment = "";
        this.summary = 0.0;
        this.summaryPass = 0.0;
        this.counter = 0;
        this.counterPass = 0;
        this.passType = "";
        this.isPass = 0;
        return this;
    }

    public FlowProcess init_ToReject(User i_User, FlowInfo i_Flow, FlowProcess io_Previous, ActivityInfo i_RejectActivity) {
        this.templateID = i_Flow.getFlowTemplateID();
        this.processID = IDHelp.makeID();
        this.serviceDataID = i_Flow.getServiceDataID();
        this.workID = i_Flow.getWorkID();
        this.splitProcessID = io_Previous.getSplitProcessID();
        this.currentActivityID = i_RejectActivity.getActivityID();
        this.currentActivityCode = i_RejectActivity.getActivityCode();
        this.currentActivityName = i_RejectActivity.getActivityName();
        this.processNo = -1;
        this.previousProcessID = io_Previous.getProcessID();
        this.previousActivityID = io_Previous.getCurrentActivityID();
        this.previousActivityCode = io_Previous.getCurrentActivityCode();
        this.previousActivityName = io_Previous.getCurrentActivityName();
        this.previousOperateTypeID = RouteTypeEnum.$Reject_Auto.getValue();
        io_Previous.nextProcessID = this.processID;
        io_Previous.nextActivityID = this.currentActivityID;
        io_Previous.nextActivityCode = this.currentActivityCode;
        io_Previous.nextActivityName = this.currentActivityName;
        this.nextProcessID = "";
        this.nextActivityID = "";
        this.nextActivityName = "";
        this.createrID = i_User.getUserID();
        this.creater = i_User.getUserName();
        this.createOrgID = i_User.getOrgID();
        this.createOrg = i_User.getOrgName();
        this.createTime = new Date();
        this.limitUserID = "";
        this.limitOrgID = "";
        this.limitTime = new Date("2000-01-01 00:00:00");
        this.operateTime = this.createTime;
        this.operateTimeLen = 0;
        this.operateTypeID = "";
        this.operateType = "";
        this.operateUserID = this.createrID;
        this.operateUser = this.creater;
        this.operateOrgID = this.createOrgID;
        this.operateOrg = this.createOrg;
        io_Previous.operateTime = this.createTime;
        io_Previous.operateTimeLen = 0;
        io_Previous.operateTypeID = RouteTypeEnum.$Reject_Auto.getValue();
        io_Previous.operateType = RouteTypeEnum.$Reject_Auto.getDesc();
        io_Previous.operateUserID = this.createrID;
        io_Previous.operateUser = this.creater;
        io_Previous.operateOrgID = this.createOrgID;
        io_Previous.operateOrg = this.createOrg;
        this.operateFiles = "";
        this.operateDatas = "";
        this.infoComment = "";
        this.summary = 0.0;
        this.summaryPass = 0.0;
        this.counter = 0;
        this.counterPass = 0;
        this.passType = "";
        this.isPass = 0;
        return this;
    }

    public Participant isParticipant(User i_User) {
        if (i_User == null) {
            return null;
        }
        if (Help.isNull(this.participants)) {
            return null;
        }
        for (Participant participant : this.participants) {
            if (ParticipantTypeEnum.$User == participant.getObjectType() || ParticipantTypeEnum.$UserSend == participant.getObjectType()) {
                if (!participant.getObjectID().equals(i_User.getUserID())) continue;
                return participant;
            }
            if (ParticipantTypeEnum.$Org == participant.getObjectType() || ParticipantTypeEnum.$OrgSend == participant.getObjectType()) {
                if (!participant.getObjectID().equals(i_User.getOrgID())) continue;
                return participant;
            }
            if (ParticipantTypeEnum.$Role != participant.getObjectType() && ParticipantTypeEnum.$RoleSend != participant.getObjectType()) continue;
            if (Help.isNull(i_User.getRoles())) {
                return null;
            }
            for (UserRole v_Role : i_User.getRoles()) {
                if (!participant.getObjectID().equals(v_Role.getRoleID())) continue;
                return participant;
            }
        }
        return null;
    }

    public List<ProcessParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<ProcessParticipant> participants) {
        this.participants = participants;
    }

    public List<ProcessParticipant> getFutureParticipants() {
        return this.futureParticipants;
    }

    public void setFutureParticipants(List<ProcessParticipant> futureParticipants) {
        this.futureParticipants = futureParticipants;
    }

    public String getProcessID() {
        return this.processID;
    }

    public void setProcessID(String i_ProcessID) {
        this.processID = i_ProcessID;
    }

    public String getWorkID() {
        return this.workID;
    }

    public void setWorkID(String i_WorkID) {
        this.workID = i_WorkID;
    }

    public String getServiceDataID() {
        return this.serviceDataID;
    }

    public void setServiceDataID(String serviceDataID) {
        this.serviceDataID = serviceDataID;
    }

    public String getSplitProcessID() {
        return this.splitProcessID;
    }

    public void setSplitProcessID(String i_SplitProcessID) {
        this.splitProcessID = i_SplitProcessID;
    }

    public Integer getProcessNo() {
        return this.processNo;
    }

    public void setProcessNo(Integer i_ProcessNo) {
        this.processNo = i_ProcessNo;
    }

    public String getCurrentActivityID() {
        return this.currentActivityID;
    }

    public void setCurrentActivityID(String i_CurrentActivityID) {
        this.currentActivityID = i_CurrentActivityID;
    }

    public String getCurrentActivityCode() {
        return this.currentActivityCode;
    }

    public void setCurrentActivityCode(String currentActivityCode) {
        this.currentActivityCode = currentActivityCode;
    }

    public String getCurrentActivityName() {
        return this.currentActivityName;
    }

    public void setCurrentActivityName(String i_CurrentActivityName) {
        this.currentActivityName = i_CurrentActivityName;
    }

    public String getPreviousProcessID() {
        return this.previousProcessID;
    }

    public void setPreviousProcessID(String i_PreviousProcessID) {
        this.previousProcessID = i_PreviousProcessID;
    }

    public String getPreviousActivityID() {
        return this.previousActivityID;
    }

    public void setPreviousActivityID(String i_PreviousActivityID) {
        this.previousActivityID = i_PreviousActivityID;
    }

    public String getNextActivityCode() {
        return this.nextActivityCode;
    }

    public void setNextActivityCode(String nextActivityCode) {
        this.nextActivityCode = nextActivityCode;
    }

    public String getPreviousActivityName() {
        return this.previousActivityName;
    }

    public void setPreviousActivityName(String i_PreviousActivityName) {
        this.previousActivityName = i_PreviousActivityName;
    }

    public String getNextProcessID() {
        return this.nextProcessID;
    }

    public void setNextProcessID(String i_NextProcessID) {
        this.nextProcessID = i_NextProcessID;
    }

    public String getNextActivityID() {
        return this.nextActivityID;
    }

    public void setNextActivityID(String i_NextActivityID) {
        this.nextActivityID = i_NextActivityID;
    }

    public String getPreviousActivityCode() {
        return this.previousActivityCode;
    }

    public void setPreviousActivityCode(String previousActivityCode) {
        this.previousActivityCode = previousActivityCode;
    }

    public String getNextActivityName() {
        return this.nextActivityName;
    }

    public void setNextActivityName(String i_NextActivityName) {
        this.nextActivityName = i_NextActivityName;
    }

    public String getCreaterID() {
        return this.createrID;
    }

    public void setCreaterID(String i_CreaterID) {
        this.createrID = i_CreaterID;
    }

    public String getCreater() {
        return this.creater;
    }

    public void setCreater(String i_Creater) {
        this.creater = i_Creater;
    }

    public String getCreateOrgID() {
        return this.createOrgID;
    }

    public void setCreateOrgID(String i_CreateOrgID) {
        this.createOrgID = i_CreateOrgID;
    }

    public String getCreateOrg() {
        return this.createOrg;
    }

    public void setCreateOrg(String i_CreateOrg) {
        this.createOrg = i_CreateOrg;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date i_CreateTime) {
        this.createTime = i_CreateTime;
    }

    public String getLimitUserID() {
        return this.limitUserID;
    }

    public void setLimitUserID(String i_LimitUserID) {
        this.limitUserID = i_LimitUserID;
    }

    public String getLimitOrgID() {
        return this.limitOrgID;
    }

    public void setLimitOrgID(String i_LimitOrgID) {
        this.limitOrgID = i_LimitOrgID;
    }

    public Date getLimitTime() {
        return this.limitTime;
    }

    public void setLimitTime(Date i_LimitTime) {
        this.limitTime = i_LimitTime;
    }

    public Date getOperateTime() {
        return this.operateTime;
    }

    public void setOperateTime(Date i_OperateTime) {
        this.operateTime = i_OperateTime;
    }

    public Integer getOperateTimeLen() {
        return this.operateTimeLen;
    }

    public void setOperateTimeLen(Integer i_OperateTimeLen) {
        this.operateTimeLen = i_OperateTimeLen;
    }

    public String getOperateTypeID() {
        return this.operateTypeID;
    }

    public void setOperateTypeID(String i_OperateTypeID) {
        this.operateTypeID = i_OperateTypeID;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public void setOperateType(String i_OperateType) {
        this.operateType = i_OperateType;
    }

    public String getOperateUserID() {
        return this.operateUserID;
    }

    public void setOperateUserID(String i_OperateUserID) {
        this.operateUserID = i_OperateUserID;
    }

    public String getOperateUser() {
        return this.operateUser;
    }

    public void setOperateUser(String i_OperateUser) {
        this.operateUser = i_OperateUser;
    }

    public String getOperateOrgID() {
        return this.operateOrgID;
    }

    public void setOperateOrgID(String i_OperateOrgID) {
        this.operateOrgID = i_OperateOrgID;
    }

    public String getOperateOrg() {
        return this.operateOrg;
    }

    public void setOperateOrg(String i_OperateOrg) {
        this.operateOrg = i_OperateOrg;
    }

    public String getOperateFiles() {
        return this.operateFiles;
    }

    public void setOperateFiles(String i_OperateFiles) {
        this.operateFiles = i_OperateFiles;
    }

    public String getOperateDatas() {
        return this.operateDatas;
    }

    public void setOperateDatas(String i_OperateDatas) {
        this.operateDatas = i_OperateDatas;
    }

    public String getInfoComment() {
        return this.infoComment;
    }

    public void setInfoComment(String i_InfoComment) {
        this.infoComment = i_InfoComment;
    }

    public String getTemplateID() {
        return this.templateID;
    }

    public void setTemplateID(String templateID) {
        this.templateID = templateID;
    }

    public Double getSummary() {
        return Help.NVL((Double)this.summary);
    }

    public Double getSummaryPass() {
        return this.summaryPass;
    }

    public void setSummary(Double summary) {
        this.summary = summary;
    }

    public void setSummaryPass(Double summaryPass) {
        this.summaryPass = summaryPass;
    }

    public Integer getIsPass() {
        return this.isPass;
    }

    public void setIsPass(Integer isPass) {
        this.isPass = isPass;
    }

    public String getPreviousOperateTypeID() {
        return this.previousOperateTypeID;
    }

    public void setPreviousOperateTypeID(String previousOperateTypeID) {
        this.previousOperateTypeID = previousOperateTypeID;
    }

    public Integer getCounter() {
        return Help.NVL((Integer)this.counter);
    }

    public Integer getCounterPass() {
        return this.counterPass;
    }

    public String getPassType() {
        return this.passType;
    }

    public void setCounter(Integer counter) {
        this.counter = counter;
    }

    public void setCounterPass(Integer counterPass) {
        this.counterPass = counterPass;
    }

    public void setPassType(String passType) {
        this.passType = passType;
    }
}

