/*
 * Decompiled with CFR 0.152.
 */
package org.hy.xflow.engine.bean;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.TablePartition;
import org.hy.common.TablePartitionRID;
import org.hy.xflow.engine.bean.ActivityInfo;
import org.hy.xflow.engine.bean.ActivityRoute;
import org.hy.xflow.engine.bean.Participant;
import org.hy.xflow.engine.common.BaseModel;
import org.hy.xflow.engine.enums.ActivityTypeEnum;

public class ActivityRouteTree
extends BaseModel {
    private static final long serialVersionUID = 5366730038571520921L;
    public static final String $AutoActivityRouteCode = "AUTO";
    private Map<String, ActivityInfo> allActivitys;
    private PartitionMap<String, ActivityRoute> allRoutes;
    private Map<String, ActivityRoute> allRoutesByID;
    private TablePartitionRID<String, ActivityRoute> allRoutesByARCode;
    private TablePartitionRID<String, ActivityRoute> allRoutesByNextACode;
    private PartitionMap<String, Participant> allActivityPs;
    private PartitionMap<String, Participant> allActivityRoutePs;
    private ActivityInfo startActivity;
    private Map<String, ActivityInfo> endActivitys;

    public ActivityRouteTree(Map<String, ActivityInfo> i_AllActivitys, PartitionMap<String, ActivityRoute> i_AllRoutes, PartitionMap<String, Participant> i_AllActivityPs, PartitionMap<String, Participant> i_AllActivityRoutePs) {
        this.allActivitys = i_AllActivitys;
        this.allRoutes = i_AllRoutes;
        this.allRoutesByID = new HashMap<String, ActivityRoute>();
        this.allRoutesByARCode = new TablePartitionRID();
        this.allRoutesByNextACode = new TablePartitionRID();
        this.allActivityPs = i_AllActivityPs;
        this.allActivityRoutePs = i_AllActivityRoutePs;
        this.endActivitys = new HashMap<String, ActivityInfo>();
        if (this.allActivityRoutePs == null) {
            this.allActivityRoutePs = new TablePartition();
        }
        if (!Help.isNull(this.allActivitys)) {
            this.startActivity = this.allActivitys.values().iterator().next();
            for (ActivityInfo v_Activity : this.allActivitys.values()) {
                if (!ActivityTypeEnum.$Finish.equals(v_Activity.getActivityTypeID())) continue;
                this.endActivitys.put(v_Activity.getActivityID(), v_Activity);
            }
        }
        this.makeActivityRouteTree();
    }

    public ActivityInfo getStartActivity() {
        return this.startActivity;
    }

    public Map<String, ActivityInfo> getEndActivity() {
        return this.endActivitys;
    }

    public Map<String, ActivityInfo> getActivitys() {
        return this.allActivitys;
    }

    public ActivityInfo getActivity(String i_ActivityCode) {
        return this.allActivitys.get(i_ActivityCode);
    }

    public Map<String, ActivityRoute> getActivityRoutes() {
        return this.allRoutesByID;
    }

    public ActivityRoute getActivityRoute(String i_ActivityCode, String i_ActivityRouteCode) {
        if ($AutoActivityRouteCode.equals(i_ActivityRouteCode)) {
            return (ActivityRoute)((Object)((Map)this.allRoutesByARCode.get((Object)i_ActivityCode)).values().iterator().next());
        }
        return (ActivityRoute)((Object)((Map)this.allRoutesByARCode.get((Object)i_ActivityCode)).get(i_ActivityRouteCode));
    }

    public ActivityRoute getActivityRouteByNext(String i_ActivityCode, String i_NextActivityCode) {
        return (ActivityRoute)((Object)((Map)this.allRoutesByNextACode.get((Object)i_ActivityCode)).get(i_NextActivityCode));
    }

    public ActivityRoute getActivityRoute(String i_ActivityRouteID) {
        return this.allRoutesByID.get(i_ActivityRouteID);
    }

    public void makeActivityRouteTree() {
        if (Help.isNull(this.allActivitys) || Help.isNull(this.allRoutes) || Help.isNull(this.allActivityPs) || this.startActivity == null || Help.isNull(this.endActivitys)) {
            return;
        }
        for (Map.Entry v_Routes : this.allRoutes.entrySet()) {
            this.allRoutesByARCode.putRows((Object)((String)v_Routes.getKey()), Help.toMap((List)((List)v_Routes.getValue()), (String)"activityRouteCode"));
            this.allRoutesByNextACode.putRows((Object)((String)v_Routes.getKey()), Help.toMap((List)((List)v_Routes.getValue()), (String)"nextActivityCode"));
            for (ActivityRoute v_Route : (List)v_Routes.getValue()) {
                this.allRoutesByID.put(v_Route.getActivityRouteID(), v_Route);
            }
        }
        this.makeActivityRouteTree(this.startActivity);
    }

    private void makeActivityRouteTree(ActivityInfo io_CurrentActivity) {
        io_CurrentActivity.setParticipants((List)this.allActivityPs.get((Object)io_CurrentActivity.getActivityID()));
        List v_CurrentARoutes = (List)this.allRoutes.get((Object)io_CurrentActivity.getActivityCode());
        if (!Help.isNull((List)v_CurrentARoutes)) {
            io_CurrentActivity.setRoutes(v_CurrentARoutes);
            for (ActivityRoute v_CurrentARoute : v_CurrentARoutes) {
                ActivityInfo v_NextActivity;
                v_CurrentARoute.setActivity(io_CurrentActivity);
                v_CurrentARoute.setParticipants((List)this.allActivityRoutePs.get((Object)v_CurrentARoute.getActivityRouteID()));
                if (Help.isNull((String)v_CurrentARoute.getNextActivityID()) || (v_NextActivity = this.allActivitys.get(v_CurrentARoute.getNextActivityCode())) == null) continue;
                v_CurrentARoute.setNextActivity(v_NextActivity);
                if (!Help.isNull(v_NextActivity.getRoutes()) || v_NextActivity == this.startActivity || this.endActivitys.containsKey(v_NextActivity.getActivityID())) continue;
                this.makeActivityRouteTree(v_NextActivity);
            }
        }
    }

    private String log(ActivityInfo i_Activity) {
        StringBuilder v_Log = new StringBuilder();
        v_Log.append("\n").append(i_Activity.getActivityName());
        if (!Help.isNull(i_Activity.getParticipants())) {
            for (int i = 0; i < i_Activity.getParticipants().size(); ++i) {
                Participant v_Participant = i_Activity.getParticipants().get(i);
                v_Log.append("\n\t\u53c2\u4e0e\u4eba").append(i + 1).append("  ").append(v_Participant.getParticipantType().getParticipantType()).append(":").append(v_Participant.getObjectName());
            }
            v_Log.append("\n");
        }
        return v_Log.toString();
    }

    private String log(ActivityRoute i_CurrentARoute) {
        StringBuilder v_Log = new StringBuilder();
        v_Log.append("\u3010").append(i_CurrentARoute.getActivity().getActivityName()).append("\u3011");
        v_Log.append("  ---").append(i_CurrentARoute.getActivityRouteName()).append("--->  ");
        v_Log.append("\u3010").append(i_CurrentARoute.getNextActivity().getActivityName()).append("\u3011");
        if (!Help.isNull(i_CurrentARoute.getParticipants())) {
            for (int i = 0; i < i_CurrentARoute.getParticipants().size(); ++i) {
                Participant v_Participant = i_CurrentARoute.getParticipants().get(i);
                v_Log.append("\n\t\u53c2\u4e0e\u4eba").append(i + 1).append("  ").append(v_Participant.getParticipantType().getParticipantType()).append(":").append(v_Participant.getObjectName());
            }
            v_Log.append("\n");
        }
        return v_Log.toString();
    }
}

