/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.heartbeat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.app.Param;
import org.hy.common.thread.Job;
import org.hy.common.thread.Jobs;
import org.hy.common.xml.XJava;
import org.hy.common.xml.annotation.Xjava;
import org.hy.common.xml.log.Logger;
import org.hy.microservice.common.BaseViewMode;
import org.hy.microservice.common.heartbeat.Heartbeat;
import org.hy.microservice.common.heartbeat.IHeartbeatCache;
import org.hy.microservice.common.heartbeat.IHeartbeatDAO;
import org.hy.microservice.common.heartbeat.IHeartbeatService;
import org.hy.microservice.common.heartbeat.task.ITask;
import org.hy.microservice.common.heartbeat.task.ITaskService;
import org.hy.microservice.common.heartbeat.task.ITaskX;

@Xjava
public class HeartbeatService
implements IHeartbeatService,
Serializable {
    private static final long serialVersionUID = -6579154134709942316L;
    private static Logger $Logger = new Logger(HeartbeatService.class);
    @Xjava
    private IHeartbeatDAO heartbeatDAO;
    @Xjava
    private IHeartbeatCache heartbeatCache;
    @Xjava(ref="MS_Common_Version")
    private Param edgeVersion;
    @Xjava(ref="MS_Common_Heartbeat_CheckCount")
    private Param heartbeatCheckCount;
    private boolean isRunning;
    private Map<String, Long> jobXIDs = new HashMap<String, Long>();
    private Map<String, String> claimTasks = new HashMap<String, String>();
    private List<ITaskX> claimTaskList;
    private String myIP = Help.getIP();
    private String myKubernetesIP;
    private String osType;
    private int invalidCount = 0;
    private boolean invalid = false;
    private long heartbeatSaveCount = 0L;

    public HeartbeatService() {
        this.claimTaskList = new ArrayList<ITaskX>();
        try {
            this.osType = System.getProperty("os.name");
            this.myKubernetesIP = System.getenv("MY_HOST_IP");
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        this.myKubernetesIP = Help.NVL((String)this.myKubernetesIP, (String)this.myIP);
    }

    @Override
    public Map<String, String> myClaimTasks() {
        return this.claimTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeat() {
        HeartbeatService heartbeatService = this;
        synchronized (heartbeatService) {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
        }
        Jobs v_Jobs = (Jobs)XJava.getObject((String)"JOBS_MS_Common");
        List<Heartbeat> v_Workers = null;
        List<ITask> v_Tasks = null;
        PartitionMap v_ClaimTask = null;
        List v_MyTasks = null;
        Long v_NowTime = Date.getNowTime().getTime();
        try {
            Heartbeat v_Heartbeat = this.saveHeartbeat();
            if (v_Heartbeat == null) {
                $Logger.error("\u4fdd\u5b58\u5fc3\u8df3\u5f02\u5e38");
                return;
            }
            Thread.sleep(5000L);
            v_Workers = this.queryByValids(((Job)XJava.getObject((String)"JOB_MS_Common_Heartbeat")).getIntervalLen() * this.heartbeatCheckCount.getValueInt() * -1);
            if (Help.isNull(v_Workers)) {
                $Logger.info("\u670d\u52a1\u8005\u5217\u8868\u4e3a\u7a7a");
                return;
            }
            ITaskService v_TaskService = (ITaskService)XJava.getObject((String)"MS_Common_Heartbeat_TaskService");
            if (v_TaskService == null) {
                $Logger.debug("\u5c1a\u672a\u5f00\u53d1\u5fc3\u8df3\u4efb\u52a1");
                return;
            }
            v_Tasks = v_TaskService.getTasks();
            if (Help.isNull(v_Tasks)) {
                $Logger.info("\u4efb\u52a1\u5217\u8868\u4e3a\u7a7a");
                return;
            }
            v_ClaimTask = Help.claimTask(v_Workers, v_Tasks);
            v_MyTasks = (List)v_ClaimTask.get((Object)v_Heartbeat);
            if (Help.isNull((List)v_MyTasks)) {
                $Logger.info("\u672c\u670d\u52a1\u8005(" + v_Heartbeat.getEdgeIP() + ")\u672a\u8ba4\u9886\u5230\u4efb\u52a1");
                if (!Help.isNull(this.claimTasks)) {
                    this.printWorkersTasks(v_Workers, v_Tasks);
                }
                return;
            }
            boolean v_IsChangeByAll = false;
            int v_Index = 0;
            this.claimTaskList.clear();
            for (ITask v_Task : v_MyTasks) {
                Return<ITaskX> v_IsChange = v_TaskService.refresh(v_Task);
                this.claimTaskList.add((ITaskX)v_IsChange.getParamObj());
                this.jobXIDs.put(v_Task.getXid(), v_NowTime);
                $Logger.info("\u8ba4\u9886\u4efb\u52a1(" + ++v_Index + "/" + v_MyTasks.size() + ")\uff1a" + (v_IsChange.booleanValue() ? "\u6709\u66f4\u65b0\u7684\uff1a" : "\u4fdd\u6301\u4e0d\u53d8\uff1a") + v_Task.getXid());
                if (!v_IsChange.booleanValue()) continue;
                v_IsChangeByAll = true;
            }
            if (v_IsChangeByAll) {
                v_Heartbeat = this.saveHeartbeat();
            }
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
        }
        finally {
            this.isRunning = false;
            this.releaseAddClaimTasks(v_NowTime, v_Jobs);
            if (v_MyTasks != null) {
                v_MyTasks.clear();
            }
            if (v_ClaimTask != null) {
                v_ClaimTask.clear();
            }
            if (v_Tasks != null) {
                v_Tasks.clear();
            }
            if (v_Workers != null) {
                v_Workers.clear();
            }
        }
    }

    private void printWorkersTasks(List<Heartbeat> i_Workers, List<ITask> i_Tasks) {
        StringBuilder v_Buffer = new StringBuilder();
        v_Buffer.append("\n");
        v_Buffer.append(StringHelp.rpad((String)"Edge IP", (int)16, (String)" "));
        v_Buffer.append(StringHelp.rpad((String)"Edge Start Time", (int)22, (String)" "));
        v_Buffer.append(StringHelp.rpad((String)"OS Time", (int)22, (String)" "));
        v_Buffer.append(StringHelp.rpad((String)"Update Time", (int)22, (String)" ")).append("\n");
        v_Buffer.append(StringHelp.rpad((String)"", (int)82, (String)"-")).append("\n");
        for (Heartbeat v_Work : i_Workers) {
            v_Buffer.append(StringHelp.rpad((String)v_Work.getEdgeIP(), (int)16, (String)" "));
            v_Buffer.append(StringHelp.rpad((String)v_Work.getEdgeStartTime(), (int)22, (String)" "));
            v_Buffer.append(StringHelp.rpad((String)v_Work.getOsTime(), (int)22, (String)" "));
            v_Buffer.append(StringHelp.rpad((Object)v_Work.getUpdateTime(), (int)22, (String)" ")).append("\n");
        }
        v_Buffer.append("\n");
        v_Buffer.append("\n");
        v_Buffer.append(StringHelp.rpad((String)"Create Time", (int)22, (String)" "));
        v_Buffer.append("Task XID").append("\n");
        v_Buffer.append(StringHelp.rpad((String)"", (int)58, (String)"-")).append("\n");
        for (ITask v_Task : i_Tasks) {
            v_Buffer.append(StringHelp.rpad((String)v_Task.getCreateTime().getFull(), (int)22, (String)" "));
            v_Buffer.append(v_Task.getXid()).append("\n");
        }
        $Logger.info(v_Buffer.toString());
    }

    private Heartbeat saveHeartbeat() {
        int v_ClaimCount = 0;
        int v_TaskOKCount = 0;
        if (!Help.isNull(this.claimTaskList)) {
            v_ClaimCount = this.claimTaskList.size();
            for (ITaskX v_TaskX : this.claimTaskList) {
                v_TaskOKCount += v_TaskX.isRunOK() ? 1 : 0;
            }
        }
        Heartbeat v_Heartbeat = new Heartbeat();
        v_Heartbeat.setEdgeIP(this.myIP);
        v_Heartbeat.setHostIP(this.myKubernetesIP);
        v_Heartbeat.setEdgeVersion(this.edgeVersion.getValue());
        v_Heartbeat.setOsType(this.osType);
        v_Heartbeat.setEdgeStartTime(BaseViewMode.$StartupTime.getFull());
        v_Heartbeat.setOsTime(Date.getNowTime().getFullMilli());
        v_Heartbeat.setClaimCount(v_ClaimCount);
        v_Heartbeat.setTaskOKCount(v_TaskOKCount);
        v_Heartbeat.setIsValid(v_ClaimCount >= 1 && v_TaskOKCount <= 0 ? -1 : 1);
        if (v_Heartbeat.getIsValid() < 1) {
            if (this.invalidCount >= this.heartbeatCheckCount.getValueInt()) {
                v_Heartbeat.setInvalidTime(new Date());
                this.invalid = true;
            } else {
                ++this.invalidCount;
                v_Heartbeat.setIsValid(1);
            }
        }
        if (this.invalid) {
            v_Heartbeat.setIsValid(-1);
        }
        return this.save(v_Heartbeat);
    }

    private void releaseAddClaimTasks(Long i_NowTime, Jobs i_Jobs) {
        ITaskService v_TaskService = (ITaskService)XJava.getObject((String)"MS_Common_Heartbeat_TaskService");
        HashMap<String, String> v_ClaimTasks = new HashMap<String, String>();
        boolean v_IsChange = false;
        if (!Help.isNull(this.jobXIDs)) {
            Iterator<String> v_JobXIDKeys = this.jobXIDs.keySet().iterator();
            while (v_JobXIDKeys.hasNext()) {
                String v_FirstTime;
                String v_TaskXID = v_JobXIDKeys.next();
                String v_JobXID_WS = "JOB_WS_" + v_TaskXID;
                String v_JobXID_DB = "JOB_DB_" + v_TaskXID;
                Long v_Time = this.jobXIDs.get(v_TaskXID);
                if (!i_NowTime.equals(v_Time)) {
                    if (XJava.getObject((String)v_JobXID_WS, (boolean)false) != null) {
                        XJava.remove((String)v_JobXID_WS);
                        this.delJobByJobs(i_Jobs, v_JobXID_WS);
                        $Logger.info("\u91ca\u653e\u4efb\u52a1\uff1a" + v_JobXID_WS);
                    }
                    if (XJava.getObject((String)v_JobXID_DB, (boolean)false) != null) {
                        XJava.remove((String)v_JobXID_DB);
                        this.delJobByJobs(i_Jobs, v_JobXID_DB);
                        $Logger.info("\u91ca\u653e\u4efb\u52a1\uff1a" + v_JobXID_DB);
                    }
                    v_JobXIDKeys.remove();
                    v_IsChange = true;
                    continue;
                }
                ITaskX v_TaskX = (ITaskX)XJava.getObject((String)v_TaskXID);
                boolean v_IsSaveIP = false;
                if (v_TaskX.isWebPush()) {
                    Job v_JobWS = (Job)XJava.getObject((String)v_JobXID_WS);
                    if (v_JobWS == null) {
                        this.addJobWebSocketByJobs(i_Jobs, v_JobXID_WS, v_TaskX);
                        v_IsChange = true;
                        v_IsSaveIP = true;
                        if (v_TaskService != null) {
                            v_TaskService.updateClaimIP(v_TaskX, this.myKubernetesIP);
                        }
                    } else if (v_JobWS.getIntervalLen() != v_TaskX.getWebPushInterval().intValue()) {
                        v_JobWS.setIntervalLen(v_TaskX.getWebPushInterval().intValue());
                        v_IsChange = true;
                    }
                    if (Help.isNull((String)(v_FirstTime = this.claimTasks.get(v_TaskX.getWebPushName())))) {
                        v_FirstTime = Date.getNowTime().getFull();
                    }
                    v_ClaimTasks.put(v_TaskX.getWebPushName(), v_FirstTime);
                }
                if (!v_TaskX.isXsql()) continue;
                Job v_JobDB = (Job)XJava.getObject((String)v_JobXID_DB);
                if (v_JobDB == null) {
                    this.addJobDatabaseByJobs(i_Jobs, v_JobXID_DB, v_TaskX);
                    v_IsChange = true;
                    if (!v_IsSaveIP && v_TaskService != null) {
                        v_TaskService.updateClaimIP(v_TaskX, this.myKubernetesIP);
                    }
                } else if (v_JobDB.getIntervalLen() != v_TaskX.getXsqlInterval().intValue()) {
                    v_JobDB.setIntervalLen(v_TaskX.getXsqlInterval().intValue());
                    v_IsChange = true;
                }
                if (Help.isNull((String)(v_FirstTime = this.claimTasks.get(v_TaskX.getXsqlXID())))) {
                    v_FirstTime = Date.getNowTime().getFull();
                }
                v_ClaimTasks.put(v_TaskX.getXsqlXID(), v_FirstTime);
            }
        }
        if (v_IsChange) {
            this.claimTasks = v_ClaimTasks;
        } else {
            v_ClaimTasks.clear();
            v_ClaimTasks = null;
        }
    }

    private void addJobWebSocketByJobs(Jobs i_Jobs, String i_Code, ITaskX i_TaskX) {
        Job v_Job = new Job();
        v_Job.setXJavaID(i_Code);
        v_Job.setCode(i_Code);
        v_Job.setName(i_TaskX.getXid());
        v_Job.setIntervalType(-2);
        v_Job.setIntervalLen(i_TaskX.getWebPushInterval().intValue());
        v_Job.setXid(i_TaskX.getXid());
        v_Job.setMethodName(i_TaskX.getWebPushExecuteName());
        v_Job.setComment(i_TaskX.getComment());
        v_Job.setStartTime(Date.getNowTime().getFirstTimeOfDay().getFull());
        XJava.putObject((String)i_Code, (Object)v_Job);
        i_Jobs.addJob(v_Job);
    }

    private void addJobDatabaseByJobs(Jobs i_Jobs, String i_Code, ITaskX i_TaskX) {
        Job v_Job = new Job();
        v_Job.setXJavaID(i_Code);
        v_Job.setCode(i_Code);
        v_Job.setName(i_TaskX.getXid());
        v_Job.setIntervalType(60);
        v_Job.setIntervalLen(i_TaskX.getXsqlInterval().intValue());
        v_Job.setXid(i_TaskX.getXid());
        v_Job.setMethodName(i_TaskX.getXsqlExecuteName());
        v_Job.setComment(i_TaskX.getComment());
        v_Job.setStartTime(Date.getNowTime().getFirstTimeOfDay().getFull());
        XJava.putObject((String)i_Code, (Object)v_Job);
        i_Jobs.addJob(v_Job);
    }

    private void delJobByJobs(Jobs i_Jobs, String i_Code) {
        Iterator v_JobList = i_Jobs.getJobs();
        while (v_JobList.hasNext()) {
            Job v_Item = (Job)v_JobList.next();
            if (!v_Item.getCode().equals(i_Code)) continue;
            i_Jobs.delJob(v_Item);
            break;
        }
    }

    @Override
    public Heartbeat save(Heartbeat i_Heartbeat) {
        if (i_Heartbeat == null) {
            return null;
        }
        ++this.heartbeatSaveCount;
        if (this.heartbeatSaveCount <= 1L) {
            this.heartbeatCache.delEdgeIP(i_Heartbeat.getEdgeIP());
            this.heartbeatDAO.delEdgeIP(i_Heartbeat.getEdgeIP());
        } else if (this.heartbeatSaveCount + 1L >= Long.MAX_VALUE) {
            this.heartbeatSaveCount = 1L;
        }
        this.heartbeatCache.save(i_Heartbeat);
        boolean v_Ret = this.heartbeatDAO.save(i_Heartbeat);
        return v_Ret ? i_Heartbeat : null;
    }

    @Override
    public Heartbeat queryByEdge(String i_EdgeIP) {
        return this.heartbeatDAO.queryByEdge(i_EdgeIP);
    }

    @Override
    public List<Heartbeat> queryByValids(Integer i_Second) {
        return this.heartbeatCache.queryByValids(i_Second);
    }

    @Override
    public List<Heartbeat> query(Heartbeat i_Heartbeat) {
        return this.heartbeatDAO.query(i_Heartbeat);
    }
}

