/*
 * Decompiled with CFR 0.152.
 */
package org.hy.microservice.common.state;

import org.hy.common.Help;
import org.hy.microservice.common.BaseEnum;

public class Transition {
    private final String fromState;
    private final String action;
    private final String toState;

    public Transition(String i_FromState, String i_Action, String i_ToState) {
        if (Help.isNull((String)i_FromState)) {
            throw new NullPointerException("FromState is null");
        }
        if (Help.isNull((String)i_Action)) {
            throw new NullPointerException("Action is null");
        }
        if (Help.isNull((String)i_ToState)) {
            throw new NullPointerException("ToState is null");
        }
        if (i_FromState.equals(i_ToState)) {
            throw new RuntimeException("FromState equals ToState ,it is error.");
        }
        this.fromState = i_FromState;
        this.action = i_Action;
        this.toState = i_ToState;
    }

    public Transition(BaseEnum<String> i_FromState, BaseEnum<String> i_Action, BaseEnum<String> i_ToState) {
        if (i_FromState == null) {
            throw new NullPointerException("FromState is null");
        }
        if (i_Action == null) {
            throw new NullPointerException("Action is null");
        }
        if (i_ToState == null) {
            throw new NullPointerException("ToState is null");
        }
        if (i_FromState == i_ToState || ((String)i_FromState.getValue()).equals(i_ToState.getValue())) {
            throw new RuntimeException("FromState equals ToState ,it is error.");
        }
        this.fromState = (String)i_FromState.getValue();
        this.action = (String)i_Action.getValue();
        this.toState = (String)i_ToState.getValue();
    }

    public String getFromState() {
        return this.fromState;
    }

    public String getAction() {
        return this.action;
    }

    public String getToState() {
        return this.toState;
    }
}

